/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import io.sf.carte.echosvg.util.CleanerThread;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SoftReferenceCache {
    protected final Map<Object, SoftReference<Object>> map = new HashMap<Object, SoftReference<Object>>();
    private final boolean synchronous;

    protected SoftReferenceCache() {
        this(false);
    }

    protected SoftReferenceCache(boolean bl) {
        this.synchronous = bl;
    }

    public synchronized void flush() {
        this.map.clear();
        this.notifyAll();
    }

    protected final synchronized boolean isPresentImpl(Object object) {
        if (!this.map.containsKey(object)) {
            return false;
        }
        SoftReference<Object> softReference = this.map.get(object);
        if (softReference == null) {
            return true;
        }
        Object object2 = softReference.get();
        if (object2 != null) {
            return true;
        }
        this.clearImpl(object);
        return false;
    }

    protected final synchronized boolean isDoneImpl(Object object) {
        SoftReference<Object> softReference = this.map.get(object);
        if (softReference == null) {
            return false;
        }
        Object object2 = softReference.get();
        if (object2 != null) {
            return true;
        }
        this.clearImpl(object);
        return false;
    }

    protected final synchronized Object requestImpl(Object object) {
        if (this.map.containsKey(object)) {
            Object object2;
            SoftReference<Object> softReference = this.map.get(object);
            while (softReference == null) {
                if (this.synchronous) {
                    return null;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.map.containsKey(object)) break;
                softReference = this.map.get(object);
            }
            if (softReference != null && (object2 = softReference.get()) != null) {
                return object2;
            }
        }
        this.map.put(object, null);
        return null;
    }

    protected final synchronized void clearImpl(Object object) {
        this.map.remove(object);
        this.notifyAll();
    }

    protected final synchronized void putImpl(Object object, Object object2) {
        if (this.map.containsKey(object)) {
            SoftRefKey softRefKey = new SoftRefKey(object2, object);
            this.map.put(object, softRefKey);
            this.notifyAll();
        }
    }

    class SoftRefKey
    extends CleanerThread.SoftReferenceCleared<Object> {
        Object key;

        public SoftRefKey(Object object, Object object2) {
            super(object);
            this.key = object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleared() {
            SoftReferenceCache softReferenceCache;
            SoftReferenceCache softReferenceCache2 = softReferenceCache = SoftReferenceCache.this;
            synchronized (softReferenceCache2) {
                if (!softReferenceCache.map.containsKey(this.key)) {
                    return;
                }
                SoftReference<Object> softReference = softReferenceCache.map.remove(this.key);
                if (this == softReference) {
                    softReferenceCache.notifyAll();
                } else {
                    softReferenceCache.map.put(this.key, softReference);
                }
            }
        }
    }
}

