/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom.util;

import io.sf.carte.echosvg.dom.util.DocumentDescriptor;
import io.sf.carte.echosvg.dom.util.DocumentFactory;
import io.sf.carte.echosvg.dom.util.HashTableStack;
import io.sf.carte.echosvg.dom.util.ResourceEntityResolver;
import io.sf.carte.echosvg.dom.util.SAXIOException;
import io.sf.carte.echosvg.util.HaltingThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SAXDocumentFactory
extends DocumentBuilder
implements LexicalHandler,
DocumentFactory,
ContentHandler,
ErrorHandler {
    private DOMImplementation implementation;
    private XMLReader parser;
    private Document document;
    private DocumentDescriptor documentDescriptor;
    private boolean createDocumentDescriptor;
    private Node currentNode;
    private Locator locator;
    private StringBuilder stringBuffer = new StringBuilder();
    private DocumentType doctype;
    private boolean stringContent;
    private boolean inDTD;
    private boolean inCDATA;
    private boolean inProlog;
    private boolean isValidating;
    private boolean isStandalone;
    private String xmlVersion;
    private HashTableStack namespaces;
    protected ErrorHandler errorHandler;
    private List<PreInfo> preInfo;
    private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();

    public SAXDocumentFactory(DOMImplementation dOMImplementation) {
        this(dOMImplementation, null);
    }

    public SAXDocumentFactory(DOMImplementation dOMImplementation, XMLReader xMLReader) {
        this(dOMImplementation, xMLReader, false);
    }

    public SAXDocumentFactory(DOMImplementation dOMImplementation, XMLReader xMLReader, boolean bl) {
        this.implementation = dOMImplementation;
        this.parser = SAXDocumentFactory.getXMLReader(xMLReader);
        this.createDocumentDescriptor = bl;
    }

    private static XMLReader getXMLReader(XMLReader xMLReader) {
        if (xMLReader == null) {
            ServiceLoader<XMLReader> serviceLoader = ServiceLoader.load(XMLReader.class);
            Iterator<XMLReader> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                xMLReader = iterator.next();
                try {
                    xMLReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                    // empty catch block
                }
                try {
                    xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    xMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {}
            } else {
                try {
                    SAXParser sAXParser = saxFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException | SAXException exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            xMLReader.setEntityResolver(SAXDocumentFactory.createEntityResolver());
        }
        return xMLReader;
    }

    @Override
    public Document createDocument(String string, String string2, String string3) throws IOException {
        return this.parseDocument(string, string2, string3, new InputSource(string3));
    }

    @Override
    public Document createDocument(String string, String string2, String string3, String string4) throws IOException {
        InputSource inputSource = new InputSource(string3);
        inputSource.setEncoding(string4);
        return this.parseDocument(string, string2, string3, inputSource);
    }

    public Document createDocument(String string) throws IOException {
        return this.parseDocument(new InputSource(string));
    }

    public Document createDocument(String string, String string2) throws IOException {
        InputSource inputSource = new InputSource(string);
        inputSource.setEncoding(string2);
        return this.parseDocument(inputSource);
    }

    @Override
    public Document createDocument(String string, String string2, String string3, InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string3);
        return this.parseDocument(string, string2, string3, inputSource);
    }

    @Override
    public Document createDocument(String string, String string2, String string3, InputStream inputStream, String string4) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string3);
        inputSource.setEncoding(string4);
        return this.parseDocument(string, string2, string3, inputSource);
    }

    public Document createDocument(String string, InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.parseDocument(inputSource);
    }

    @Override
    public Document createDocument(String string, String string2, String string3, Reader reader) throws IOException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string3);
        return this.parseDocument(string, string2, string3, inputSource);
    }

    @Override
    @Deprecated
    public Document createDocument(String string, String string2, String string3, XMLReader xMLReader) throws IOException {
        xMLReader.setContentHandler(this);
        if (xMLReader.getEntityResolver() == null) {
            xMLReader.setEntityResolver(SAXDocumentFactory.createEntityResolver());
        }
        try {
            xMLReader.parse(string3);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof InterruptedIOException) {
                throw (InterruptedIOException)exception;
            }
            throw new SAXIOException(sAXException);
        }
        this.currentNode = null;
        Document document = this.document;
        this.document = null;
        this.doctype = null;
        document.setDocumentURI(string3);
        return document;
    }

    private static EntityResolver createEntityResolver() {
        return new ResourceEntityResolver();
    }

    public Document createDocument(String string, Reader reader) throws IOException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        return this.parseDocument(inputSource);
    }

    private Document parseDocument(String string, String string2, String string3, InputSource inputSource) throws IOException {
        Document document = this.createDocument(string, string2, string3, inputSource);
        document.setDocumentURI(string3);
        return document;
    }

    protected Document createDocument(String string, String string2, String string3, InputSource inputSource) throws IOException {
        String string4;
        this.checkRootElement(string, string2);
        Document document = this.createDocument(inputSource);
        Element element = document.getDocumentElement();
        String string5 = string2;
        String string6 = string;
        if (string == null) {
            int n = string5.indexOf(58);
            String string7 = n == -1 || n == string5.length() - 1 ? "" : string5.substring(0, n);
            string6 = this.namespaces.get(string7);
            if (n != -1 && n != string5.length() - 1) {
                string5 = string5.substring(n + 1);
            }
        }
        if ((string4 = element.getNamespaceURI()) != string6 && string4 != null && !string4.equals(string6)) {
            throw new IOException("Root element namespace does not match that requested:\nRequested: " + string6 + "\nFound: " + string4);
        }
        if (string4 != null) {
            if (!element.getLocalName().equals(string5)) {
                throw new IOException("Root element does not match that requested:\nRequested: " + string5 + "\nFound: " + element.getLocalName());
            }
        } else if (!element.getNodeName().equals(string5)) {
            throw new IOException("Root element does not match that requested:\nRequested: " + string5 + "\nFound: " + element.getNodeName());
        }
        return document;
    }

    protected void checkRootElement(String string, String string2) {
    }

    private Document parseDocument(InputSource inputSource) throws IOException {
        Document document = this.createDocument(inputSource);
        document.setDocumentURI(inputSource.getSystemId());
        return document;
    }

    protected Document createDocument(InputSource inputSource) throws IOException {
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this.errorHandler == null ? this : this.errorHandler);
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", this.isValidating);
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof InterruptedIOException) {
                throw (InterruptedIOException)exception;
            }
            throw new SAXIOException(sAXException);
        }
        this.currentNode = null;
        Document document = this.document;
        this.document = null;
        this.doctype = null;
        this.locator = null;
        return document;
    }

    @Override
    public DocumentDescriptor getDocumentDescriptor() {
        return this.documentDescriptor;
    }

    @Override
    public void setXMLReader(XMLReader xMLReader) {
        this.parser = SAXDocumentFactory.getXMLReader(xMLReader);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void setValidating(boolean bl) {
        this.isValidating = bl;
        if (this.parser.getEntityResolver() == null) {
            if (bl) {
                this.parser.setEntityResolver(SAXDocumentFactory.createEntityResolver());
            } else {
                this.secureReader();
            }
        }
    }

    @Override
    public boolean isValidating() {
        return this.isValidating;
    }

    protected boolean isStandalone() {
        return this.isStandalone;
    }

    protected String getXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public DOMImplementation getDOMImplementation(String string) {
        return this.implementation;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.implementation;
    }

    @Override
    public Document parse(InputSource inputSource) throws SAXException, IOException {
        return this.parseDocument(inputSource);
    }

    @Override
    public boolean isNamespaceAware() {
        try {
            return this.parser.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            return false;
        }
    }

    @Override
    public boolean isXIncludeAware() {
        try {
            return this.parser.getFeature("http://apache.org/xml/features/xinclude");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            return false;
        }
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
        if (entityResolver == null) {
            this.secureReader();
        }
    }

    private void secureReader() {
        this.isValidating = false;
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        try {
            this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        try {
            this.parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            this.parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }

    @Override
    public Document newDocument() {
        return this.implementation.createDocument(null, null, null);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.initPreInfo();
        this.namespaces = new HashTableStack();
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
        this.namespaces.put("", null);
        this.inDTD = false;
        this.inCDATA = false;
        this.inProlog = true;
        this.currentNode = null;
        this.document = null;
        this.doctype = null;
        this.isStandalone = false;
        this.xmlVersion = "1.0";
        this.stringBuffer.setLength(0);
        this.stringContent = false;
        this.documentDescriptor = this.createDocumentDescriptor ? new DocumentDescriptor() : null;
    }

    protected void initPreInfo() {
        this.preInfo = new LinkedList<PreInfo>();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        Element element;
        String string4;
        if (HaltingThread.hasBeenHalted()) {
            throw new SAXException(new InterruptedIOException());
        }
        if (this.inProlog) {
            this.inProlog = false;
            if (this.parser != null) {
                try {
                    this.isStandalone = this.parser.getFeature("http://xml.org/sax/features/is-standalone");
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
                try {
                    this.xmlVersion = (String)this.parser.getProperty("http://xml.org/sax/properties/document-xml-version");
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
        }
        int n = attributes.getLength();
        this.namespaces.push();
        String string5 = null;
        for (int i = 0; i < n; ++i) {
            String string6 = attributes.getQName(i);
            int n2 = string6.length();
            if (n2 < 5) continue;
            if (string6.equals("version")) {
                string5 = attributes.getValue(i);
                continue;
            }
            if (!string6.startsWith("xmlns")) continue;
            if (n2 == 5) {
                string4 = attributes.getValue(i);
                if (string4.length() == 0) {
                    string4 = null;
                }
                this.namespaces.put("", string4);
                continue;
            }
            if (string6.charAt(5) != ':') continue;
            string4 = attributes.getValue(i);
            if (string4.length() == 0) {
                string4 = null;
            }
            this.namespaces.put(string6.substring(6), string4);
        }
        this.appendStringData();
        int n3 = string3.indexOf(58);
        String string7 = n3 == -1 || n3 == string3.length() - 1 ? "" : string3.substring(0, n3);
        string4 = this.namespaces.get(string7);
        if (this.currentNode == null) {
            this.implementation = this.getDOMImplementation(string5);
            this.document = this.implementation.createDocument(string4, string3, this.doctype);
            Iterator<PreInfo> iterator = this.preInfoIterator();
            element = this.document.getDocumentElement();
            this.currentNode = element;
            while (iterator.hasNext()) {
                object = iterator.next();
                Node node = object.createNode(this.document);
                this.document.insertBefore(node, element);
            }
            this.preInfo = null;
        } else {
            element = this.document.createElementNS(string4, string3);
            this.currentNode.appendChild(element);
            this.currentNode = element;
        }
        if (this.createDocumentDescriptor && this.locator != null) {
            this.documentDescriptor.setLocation(element, this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        for (int i = 0; i < n; ++i) {
            object = attributes.getQName(i);
            if (((String)object).equals("xmlns")) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", (String)object, attributes.getValue(i));
                continue;
            }
            n3 = ((String)object).indexOf(58);
            string4 = n3 == -1 ? null : this.namespaces.get(((String)object).substring(0, n3));
            element.setAttributeNS(string4, (String)object, attributes.getValue(i));
        }
    }

    protected Iterator<PreInfo> preInfoIterator() {
        return this.preInfo.iterator();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.appendStringData();
        if (this.currentNode != null) {
            this.currentNode = this.currentNode.getParentNode();
        }
        this.namespaces.pop();
    }

    public void appendStringData() {
        if (!this.stringContent) {
            return;
        }
        String string = this.stringBuffer.toString();
        this.stringBuffer.setLength(0);
        this.stringContent = false;
        if (this.currentNode == null) {
            if (this.inCDATA) {
                this.addPreInfo(new CDataInfo(string));
            } else {
                this.addPreInfo(new TextInfo(string));
            }
        } else {
            Text text = this.inCDATA ? this.document.createCDATASection(string) : this.document.createTextNode(string);
            this.currentNode.appendChild(text);
        }
    }

    protected void addPreInfo(PreInfo preInfo) {
        this.preInfo.add(preInfo);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.stringBuffer.append(cArray, n, n2);
        this.stringContent = true;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.stringBuffer.append(cArray, n, n2);
        this.stringContent = true;
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.appendStringData();
        if (this.currentNode == null) {
            this.addPreInfo(new ProcessingInstructionInfo(string, string2));
        } else {
            this.currentNode.appendChild(this.document.createProcessingInstruction(string, string2));
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.appendStringData();
        this.doctype = this.implementation.createDocumentType(string, string2, string3);
        this.inDTD = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.appendStringData();
        this.inCDATA = true;
        this.stringContent = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.appendStringData();
        this.inCDATA = false;
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.appendStringData();
        String string = new String(cArray, n, n2);
        if (this.currentNode == null) {
            this.addPreInfo(new CommentInfo(string));
        } else {
            this.currentNode.appendChild(this.document.createComment(string));
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    static {
        try {
            saxFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            saxFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            saxFactory.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
    }

    private static class CDataInfo
    implements PreInfo {
        public String cdata;

        public CDataInfo(String string) {
            this.cdata = string;
        }

        @Override
        public Node createNode(Document document) {
            return document.createCDATASection(this.cdata);
        }
    }

    private static class CommentInfo
    implements PreInfo {
        public String comment;

        public CommentInfo(String string) {
            this.comment = string;
        }

        @Override
        public Node createNode(Document document) {
            return document.createComment(this.comment);
        }
    }

    protected static interface PreInfo {
        public Node createNode(Document var1);
    }

    private static class ProcessingInstructionInfo
    implements PreInfo {
        public String target;
        public String data;

        public ProcessingInstructionInfo(String string, String string2) {
            this.target = string;
            this.data = string2;
        }

        @Override
        public Node createNode(Document document) {
            return document.createProcessingInstruction(this.target, this.data);
        }
    }

    private static class TextInfo
    implements PreInfo {
        public String text;

        public TextInfo(String string) {
            this.text = string;
        }

        @Override
        public Node createNode(Document document) {
            return document.createTextNode(this.text);
        }
    }
}

