/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.optimizer.Block;
import org.mozilla.javascript.optimizer.OptFunctionNode;

class Optimizer {
    static final int NoType = 0;
    static final int NumberType = 1;
    static final int AnyType = 3;
    private boolean inDirectCallFunction;
    OptFunctionNode theFunction;
    private boolean parameterUsedInNumberContext;

    Optimizer() {
    }

    void optimize(ScriptNode scriptNode) {
        int n = scriptNode.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptNode, i);
            this.optimizeFunction(optFunctionNode);
        }
    }

    private void optimizeFunction(OptFunctionNode optFunctionNode) {
        if (optFunctionNode.fnode.requiresActivation()) {
            return;
        }
        this.inDirectCallFunction = optFunctionNode.isTargetOfDirectCall();
        this.theFunction = optFunctionNode;
        ObjArray objArray = new ObjArray();
        Optimizer.buildStatementList_r(optFunctionNode.fnode, objArray);
        Object[] objectArray = new Node[objArray.size()];
        objArray.toArray(objectArray);
        Block.runFlowAnalyzes(optFunctionNode, (Node[])objectArray);
        if (!optFunctionNode.fnode.requiresActivation()) {
            this.parameterUsedInNumberContext = false;
            for (Object object : objectArray) {
                this.rewriteForNumberVariables((Node)object, 1);
            }
            optFunctionNode.setParameterNumberContext(this.parameterUsedInNumberContext);
        }
    }

    private void markDCPNumberContext(Node node) {
        int n;
        if (this.inDirectCallFunction && node.getType() == 55 && this.theFunction.isParameter(n = this.theFunction.getVarIndex(node))) {
            this.parameterUsedInNumberContext = true;
        }
    }

    private boolean convertParameter(Node node) {
        int n;
        if (this.inDirectCallFunction && node.getType() == 55 && this.theFunction.isParameter(n = this.theFunction.getVarIndex(node))) {
            node.removeProp(8);
            return true;
        }
        return false;
    }

    private int rewriteForNumberVariables(Node node, int n) {
        switch (node.getType()) {
            case 137: {
                Node node2 = node.getFirstChild();
                int n2 = this.rewriteForNumberVariables(node2, 1);
                if (n2 == 1) {
                    node.putIntProp(8, 0);
                }
                return 0;
            }
            case 40: {
                node.putIntProp(8, 0);
                return 1;
            }
            case 55: {
                int n3 = this.theFunction.getVarIndex(node);
                if (this.inDirectCallFunction && this.theFunction.isParameter(n3) && n == 1) {
                    node.putIntProp(8, 0);
                    return 1;
                }
                if (this.theFunction.isNumberVar(n3)) {
                    node.putIntProp(8, 0);
                    return 1;
                }
                return 0;
            }
            case 110: 
            case 111: {
                Node node3 = node.getFirstChild();
                int n4 = this.rewriteForNumberVariables(node3, 1);
                if (node3.getType() == 55) {
                    if (n4 == 1 && !this.convertParameter(node3)) {
                        node.putIntProp(8, 0);
                        this.markDCPNumberContext(node3);
                        return 1;
                    }
                    return 0;
                }
                if (node3.getType() == 36 || node3.getType() == 33) {
                    return n4;
                }
                return 0;
            }
            case 56: 
            case 160: {
                Node node4 = node.getFirstChild();
                Node node5 = node4.getNext();
                int n5 = this.rewriteForNumberVariables(node5, 1);
                int n6 = this.theFunction.getVarIndex(node);
                if (this.inDirectCallFunction && this.theFunction.isParameter(n6)) {
                    if (n5 == 1) {
                        if (!this.convertParameter(node5)) {
                            node.putIntProp(8, 0);
                            return 1;
                        }
                        this.markDCPNumberContext(node5);
                        return 0;
                    }
                    return n5;
                }
                if (this.theFunction.isNumberVar(n6)) {
                    if (n5 != 1) {
                        node.removeChild(node5);
                        node.addChildToBack(new Node(154, node5));
                    }
                    node.putIntProp(8, 0);
                    this.markDCPNumberContext(node5);
                    return 1;
                }
                if (n5 == 1 && !this.convertParameter(node5)) {
                    node.removeChild(node5);
                    node.addChildToBack(new Node(153, node5));
                }
                return 0;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                Node node6 = node.getFirstChild();
                Node node7 = node6.getNext();
                int n7 = this.rewriteForNumberVariables(node6, 1);
                int n8 = this.rewriteForNumberVariables(node7, 1);
                this.markDCPNumberContext(node6);
                this.markDCPNumberContext(node7);
                if (this.convertParameter(node6)) {
                    if (this.convertParameter(node7)) {
                        return 0;
                    }
                    if (n8 == 1) {
                        node.putIntProp(8, 2);
                    }
                } else if (this.convertParameter(node7)) {
                    if (n7 == 1) {
                        node.putIntProp(8, 1);
                    }
                } else if (n7 == 1) {
                    if (n8 == 1) {
                        node.putIntProp(8, 0);
                    } else {
                        node.putIntProp(8, 1);
                    }
                } else if (n8 == 1) {
                    node.putIntProp(8, 2);
                }
                return 0;
            }
            case 21: {
                Node node8 = node.getFirstChild();
                Node node9 = node8.getNext();
                int n9 = this.rewriteForNumberVariables(node8, 1);
                int n10 = this.rewriteForNumberVariables(node9, 1);
                if (this.convertParameter(node8)) {
                    if (this.convertParameter(node9)) {
                        return 0;
                    }
                    if (n10 == 1) {
                        node.putIntProp(8, 2);
                    }
                } else if (this.convertParameter(node9)) {
                    if (n9 == 1) {
                        node.putIntProp(8, 1);
                    }
                } else if (n9 == 1) {
                    if (n10 == 1) {
                        node.putIntProp(8, 0);
                        return 1;
                    }
                    node.putIntProp(8, 1);
                } else if (n10 == 1) {
                    node.putIntProp(8, 2);
                }
                return 0;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 75: {
                Node node10 = node.getFirstChild();
                Node node11 = node10.getNext();
                int n11 = this.rewriteForNumberVariables(node10, 1);
                int n12 = this.rewriteForNumberVariables(node11, 1);
                this.markDCPNumberContext(node10);
                this.markDCPNumberContext(node11);
                if (n11 == 1) {
                    if (n12 == 1) {
                        node.putIntProp(8, 0);
                        return 1;
                    }
                    if (!this.convertParameter(node11)) {
                        node.removeChild(node11);
                        node.addChildToBack(new Node(154, node11));
                        node.putIntProp(8, 0);
                    }
                    return 1;
                }
                if (n12 == 1) {
                    if (!this.convertParameter(node10)) {
                        node.removeChild(node10);
                        node.addChildToFront(new Node(154, node10));
                        node.putIntProp(8, 0);
                    }
                    return 1;
                }
                return 3;
            }
            case 27: 
            case 28: 
            case 29: {
                Node node12 = node.getFirstChild();
                int n13 = this.rewriteForNumberVariables(node12, 1);
                if (n13 == 1 && !this.convertParameter(node12)) {
                    node.putIntProp(8, 0);
                    this.markDCPNumberContext(node12);
                    return 1;
                }
                return 0;
            }
            case 37: 
            case 144: {
                int n14;
                int n15;
                Node node13 = node.getFirstChild();
                Node node14 = node13.getNext();
                Node node15 = node14.getNext();
                int n16 = this.rewriteForNumberVariables(node13, 1);
                if (n16 == 1 && !this.convertParameter(node13)) {
                    node.removeChild(node13);
                    node.addChildToFront(new Node(153, node13));
                }
                if ((n15 = this.rewriteForNumberVariables(node14, 1)) == 1 && !this.convertParameter(node14)) {
                    node.putIntProp(8, 1);
                }
                if ((n14 = this.rewriteForNumberVariables(node15, 1)) == 1 && !this.convertParameter(node15)) {
                    node.removeChild(node15);
                    node.addChildToBack(new Node(153, node15));
                }
                return 0;
            }
            case 36: {
                int n17;
                Node node16 = node.getFirstChild();
                Node node17 = node16.getNext();
                int n18 = this.rewriteForNumberVariables(node16, 1);
                if (n18 == 1 && !this.convertParameter(node16)) {
                    node.removeChild(node16);
                    node.addChildToFront(new Node(153, node16));
                }
                if ((n17 = this.rewriteForNumberVariables(node17, 1)) == 1 && !this.convertParameter(node17)) {
                    node.putIntProp(8, 2);
                }
                return 0;
            }
            case 38: {
                Node node18 = node.getFirstChild();
                this.rewriteAsObjectChildren(node18, node18.getFirstChild());
                OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(9);
                if (optFunctionNode != null) {
                    for (node18 = node18.getNext(); node18 != null; node18 = node18.getNext()) {
                        int n19 = this.rewriteForNumberVariables(node18, 1);
                        if (n19 != 1) continue;
                        this.markDCPNumberContext(node18);
                    }
                } else {
                    this.rewriteAsObjectChildren(node, node18);
                }
                return 0;
            }
        }
        this.rewriteAsObjectChildren(node, node.getFirstChild());
        return 0;
    }

    private void rewriteAsObjectChildren(Node node, Node node2) {
        while (node2 != null) {
            Node node3 = node2.getNext();
            int n = this.rewriteForNumberVariables(node2, 0);
            if (n == 1 && !this.convertParameter(node2)) {
                node.removeChild(node2);
                Node node4 = new Node(153, node2);
                if (node3 == null) {
                    node.addChildToBack(node4);
                } else {
                    node.addChildBefore(node4, node3);
                }
            }
            node2 = node3;
        }
    }

    private static void buildStatementList_r(Node node, ObjArray objArray) {
        int n = node.getType();
        if (n == 133 || n == 145 || n == 136 || n == 113) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                Optimizer.buildStatementList_r(node2, objArray);
            }
        } else {
            objArray.add(node);
        }
    }
}

