/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Slot;

public class LambdaSlot
extends Slot {
    private static final long serialVersionUID = -3046681698806493052L;
    transient Supplier<Object> getter;
    transient Consumer<Object> setter;

    LambdaSlot(Slot slot) {
        super(slot);
    }

    @Override
    boolean isValueSlot() {
        return false;
    }

    @Override
    boolean isSetterSlot() {
        return false;
    }

    @Override
    ScriptableObject getPropertyDescriptor(Context context, Scriptable scriptable) {
        ScriptableObject scriptableObject = (ScriptableObject)context.newObject(scriptable);
        if (this.getter != null) {
            scriptableObject.defineProperty("value", this.getter.get(), 0);
        } else {
            scriptableObject.defineProperty("value", this.value, 0);
        }
        scriptableObject.setCommonDescriptorProperties(this.getAttributes(), true);
        return scriptableObject;
    }

    @Override
    public boolean setValue(Object object, Scriptable scriptable, Scriptable scriptable2, boolean bl) {
        if (this.setter != null) {
            if (scriptable == scriptable2) {
                this.setter.accept(object);
                return true;
            }
            return false;
        }
        return super.setValue(object, scriptable, scriptable2, bl);
    }

    @Override
    public Object getValue(Scriptable scriptable) {
        if (this.getter != null) {
            return this.getter.get();
        }
        return super.getValue(scriptable);
    }
}

