/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.SplitPaneLayoutManager2Decorator;
import org.freeplane.main.application.SplitPaneLayoutManagerDecorator;

class AuxillaryEditorSplitPane
extends JSplitPane {
    private static final String AUX_SPLIT_PANE_LAST_POSITION = "aux_split_pane_last_position";
    private static final long serialVersionUID = 1L;
    private JComponent auxillaryComponent;
    private Component mainComponent;
    private boolean dividerLocationIsRestored;
    private static String auxillaryComponentLocation = ResourceController.getResourceController().getProperty("note_location", "bottom");
    private final ApplicationResourceController resourceController = (ApplicationResourceController)ResourceController.getResourceController();
    private String mode;

    public AuxillaryEditorSplitPane(Component mainComponent) {
        this.mainComponent = mainComponent;
        if ("top".equals(auxillaryComponentLocation) || "left".equals(auxillaryComponentLocation)) {
            this.setLeftComponent(null);
            this.setRightComponent(mainComponent);
        } else {
            this.setLeftComponent(mainComponent);
            this.setRightComponent(null);
        }
        this.dividerLocationIsRestored = false;
        this.setResizeWeight(0.5);
        this.setContinuousLayout(true);
        this.setOneTouchExpandable(false);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return false;
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (layout == null || layout instanceof SplitPaneLayoutManagerDecorator) {
            super.setLayout(layout);
        } else if (layout instanceof LayoutManager2) {
            super.setLayout(new SplitPaneLayoutManager2Decorator((LayoutManager2)layout));
        } else {
            super.setLayout(new SplitPaneLayoutManagerDecorator(layout));
        }
    }

    void insertComponentIntoSplitPane(JComponent pAuxillaryComponent, String mode) {
        this.mode = mode;
        this.insertComponentIntoSplitPane(pAuxillaryComponent);
    }

    private void insertComponentIntoSplitPane(JComponent pAuxillaryComponent) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if ("right".equals(auxillaryComponentLocation) || "left".equals(auxillaryComponentLocation)) {
            if (this.getOrientation() != 1) {
                this.setOrientation(1);
                this.dividerLocationIsRestored = false;
            }
        } else if (this.getOrientation() != 0) {
            this.setOrientation(0);
            this.dividerLocationIsRestored = false;
        }
        if ("top".equals(auxillaryComponentLocation) || "left".equals(auxillaryComponentLocation)) {
            if (this.getRightComponent() != this.mainComponent) {
                this.repositionComponent(this.mainComponent, "right");
            }
            if (this.getLeftComponent() != pAuxillaryComponent) {
                if (this.auxillaryComponent == pAuxillaryComponent) {
                    this.repositionComponent(this.auxillaryComponent, "left");
                } else {
                    this.auxillaryComponent = pAuxillaryComponent;
                    this.setLeftComponent(pAuxillaryComponent);
                }
            }
        } else {
            if (this.getLeftComponent() != this.mainComponent) {
                this.repositionComponent(this.mainComponent, "left");
                this.dividerLocationIsRestored = false;
            }
            if (this.getRightComponent() != pAuxillaryComponent) {
                if (this.auxillaryComponent == pAuxillaryComponent) {
                    this.repositionComponent(this.auxillaryComponent, "right");
                } else {
                    this.auxillaryComponent = pAuxillaryComponent;
                    this.setRightComponent(pAuxillaryComponent);
                }
                this.dividerLocationIsRestored = false;
            }
        }
        if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this)) {
            focusOwner.requestFocusInWindow();
        }
        this.revalidate();
        this.repaint();
    }

    private void repositionComponent(Component component, String constraints) {
        LayoutManager layoutMgr;
        if ("right".equals(constraints)) {
            this.rightComponent = component;
            if (this.leftComponent == component) {
                this.leftComponent = null;
            }
        } else {
            this.leftComponent = component;
            if (this.rightComponent == component) {
                this.rightComponent = null;
            }
        }
        if ((layoutMgr = this.getLayout()) != null) {
            layoutMgr.removeLayoutComponent(component);
            if (layoutMgr instanceof LayoutManager2) {
                ((LayoutManager2)layoutMgr).addLayoutComponent(component, constraints);
            } else {
                layoutMgr.addLayoutComponent(constraints, component);
            }
        }
    }

    @Override
    protected void validateTree() {
        boolean dividerLocationWasRestored = this.dividerLocationIsRestored;
        int dividerLocation = this.getDividerLocation();
        this.dividerLocationIsRestored = false;
        super.validateTree();
        this.dividerLocationIsRestored = dividerLocationWasRestored && dividerLocation == this.getDividerLocation();
        this.restoreDividerLocation();
    }

    private void restoreDividerLocation() {
        if (this.dividerLocationIsRestored || this.auxillaryComponent == null) {
            return;
        }
        double lastSplitPanePosition = Double.NaN;
        lastSplitPanePosition = "left".equals(auxillaryComponentLocation) || "top".equals(auxillaryComponentLocation) ? 1.0 - this.resourceController.getDoubleProperty(AUX_SPLIT_PANE_LAST_POSITION, Double.NaN) : this.resourceController.getDoubleProperty(AUX_SPLIT_PANE_LAST_POSITION, Double.NaN);
        if (Double.isNaN(lastSplitPanePosition)) {
            this.setDividerLocation(0.5);
        } else if (this.getProportionalDividerLocation() != lastSplitPanePosition) {
            this.setDividerLocation(lastSplitPanePosition);
        }
        this.dividerLocationIsRestored = true;
        this.invalidate();
        super.validateTree();
    }

    @Override
    public void setDividerLocation(int location) {
        super.setDividerLocation(location);
        if (this.dividerLocationIsRestored) {
            this.saveSplitPanePosition();
        }
    }

    private void saveSplitPanePosition() {
        double proportionalLocation = this.getProportionalDividerLocation();
        if ("left".equals(auxillaryComponentLocation) || "top".equals(auxillaryComponentLocation)) {
            this.resourceController.setProperty(AUX_SPLIT_PANE_LAST_POSITION, String.valueOf(1.0 - proportionalLocation));
        } else {
            this.resourceController.setProperty(AUX_SPLIT_PANE_LAST_POSITION, String.valueOf(proportionalLocation));
        }
    }

    public double getProportionalDividerLocation() {
        if (this.getOrientation() == 0) {
            int height = this.getHeight() - this.getDividerSize();
            return height > 0 ? (double)this.getDividerLocation() / (double)height : 0.0;
        }
        int width = this.getWidth() - this.getDividerSize();
        return width > 0 ? (double)this.getDividerLocation() / (double)width : 0.0;
    }

    public void changeNoteWindowLocation(String location) {
        if (location == null || location.equals(auxillaryComponentLocation)) {
            return;
        }
        auxillaryComponentLocation = this.resourceController.getProperty("note_location");
        if (this.getLeftComponent() != null && this.getRightComponent() != null) {
            this.insertComponentIntoSplitPane(this.auxillaryComponent);
        }
    }

    public JComponent getAuxiliaryComponent() {
        return this.auxillaryComponent;
    }

    @Override
    public void remove(Component component) {
        if (component == this.auxillaryComponent) {
            this.removeAuxiliaryComponent();
        } else {
            super.remove(component);
        }
    }

    void removeAuxiliaryComponent() {
        if (this.auxillaryComponent != null) {
            super.remove(this.auxillaryComponent);
            this.auxillaryComponent = null;
            this.dividerLocationIsRestored = false;
        }
    }

    public void moveAuxillaryComponentTo(AuxillaryEditorSplitPane toSplitPane, String targetMode) {
        if (this.auxillaryComponent != null) {
            boolean isModeSame = targetMode.equals(this.mode);
            if (isModeSame) {
                toSplitPane.insertComponentIntoSplitPane(this.auxillaryComponent, this.mode);
            } else {
                this.removeAuxiliaryComponent();
            }
        }
    }
}

