# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the resource. This is a read-only property and any attempt to set
    this value will be ignored.
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class RecordType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    A = "A"
    AAAA = "AAAA"
    CNAME = "CNAME"
    MX = "MX"
    PTR = "PTR"
    SOA = "SOA"
    SRV = "SRV"
    TXT = "TXT"

class VirtualNetworkLinkState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the virtual network link to the Private DNS zone. Possible values are
    'InProgress' and 'Done'. This is a read-only property and any attempt to set this value will be
    ignored.
    """

    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
