'''OpenGL extension EXT.index_material

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.index_material to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extends color index lighting to include a way for the current
	index to contribute to the color index produced by lighting.  This
	works much like ColorMaterial does for RGBA lighting by allowing
	one or more color index material properties to be attached to the
	current index.
	
	The color index lighting formula is also modified so that the lit
	color index may be bitwise shifted in order to allow greater control
	when using lighting and fog together in color index mode.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/index_material.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.index_material import *
from OpenGL.raw.GL.EXT.index_material import _EXTENSION_NAME

def glInitIndexMaterialEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION