// Generated by gmmproc 2.66.8 -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SEARCHCONTEXT_H
#define _GTKSOURCEVIEWMM_SEARCHCONTEXT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* searchcontext.h
 *
 * Copyright (C) 2015 Christoph Brill
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtksourceviewmm/buffer.h>
#include <gtksourceviewmm/searchsettings.h>
#include <gtksourceviewmm/style.h>

#include <gtkmm/textbuffer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkSourceSearchContext = struct _GtkSourceSearchContext;
using GtkSourceSearchContextClass = struct _GtkSourceSearchContextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gsv
{ class  SearchContext_Class; } // namespace Gsv
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gsv
{

  using namespace Gtk;

/** Compose a Buffer for printing.
 *
 * @newin{3,10}
 */

class SearchContext : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = SearchContext;
  using CppClassType = SearchContext_Class;
  using BaseObjectType = GtkSourceSearchContext;
  using BaseClassType = GtkSourceSearchContextClass;

  // noncopyable
  SearchContext(const SearchContext&) = delete;
  SearchContext& operator=(const SearchContext&) = delete;

private:  friend class SearchContext_Class;
  static CppClassType searchcontext_class_;

protected:
  explicit SearchContext(const Glib::ConstructParams& construct_params);
  explicit SearchContext(GtkSourceSearchContext* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  SearchContext(SearchContext&& src) noexcept;
  SearchContext& operator=(SearchContext&& src) noexcept;

  ~SearchContext() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceSearchContext*       gobj()       { return reinterpret_cast<GtkSourceSearchContext*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceSearchContext* gobj() const { return reinterpret_cast<GtkSourceSearchContext*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceSearchContext* gobj_copy();

private:


protected:

  /** Creates a new search context, associated with buffer , and customized with settings . If settings is NULL, a new GtkSourceSearchSettings object will be
   * created, that you can retrieve with gtk_source_search_context_get_settings().
   *
   * @param buffer a GtkSourceBuffer.
   * @param settings a GtkSourceSearchSettings, or NULL.
   *
   * @newin{3,10}
   */
    explicit SearchContext(const Glib::RefPtr<Buffer>& buffer, const Glib::RefPtr<SearchSettings>& settings);


public:

  
  static Glib::RefPtr<SearchContext> create(const Glib::RefPtr<Buffer>& buffer, const Glib::RefPtr<SearchSettings>& settings);

 
  /**
   * @return the associated buffer.
   *
   * @newin{3,10}
   */
  Glib::RefPtr<Buffer> get_buffer();
  
  /** @newin{3,10}
   * 
   * @return The associated buffer.
   */
  Glib::RefPtr<const Buffer> get_buffer() const;

  
  /**
   * @return the search settings.
   *
   * @newin{3,10}
   */
  Glib::RefPtr<SearchSettings> get_settings();
  
  /** @newin{3,10}
   * 
   * @return The search settings.
   */
  Glib::RefPtr<const SearchSettings> get_settings() const;

  //gtkmmproc error: gtk_source_search_context_set_settings : method defs lookup failed (1)

  
  /**
   * @return whether to highlight the search occurrences.
   *
   * @newin{3,10}
   */
  bool get_highlight() const;

  
  /** Enables or disables the search occurrences highlighting.
   *
   * @param highlight the setting.
   *
   * @newin{3,10}
   */
  void set_highlight(bool highlight =  true);

  
  /**
   * @return the GtkSourceStyle to apply on search matches.
   *
   * @newin{3,16}
   */
  Glib::RefPtr<Style> get_match_style();
  
  /** @newin{3,16}
   * 
   * @return The Gtk::SourceStyle to apply on search matches.
   */
  Glib::RefPtr<const Style> get_match_style() const;

  
  /** Set the style to apply on search matches. If match_style is NULL, default theme's scheme 'match-style' will be used. To enable or disable
   * the search highlighting, use gtk_source_search_context_set_highlight().
   *
   * @param match_style a GtkSourceStyle.
   *
   * @newin{3,16}
   */
  void set_match_style(const Glib::RefPtr<Style>& match_style);

  
  /** Gets the total number of search occurrences. If the buffer is not already fully scanned, the total number of occurrences is unknown, and -1 is returned.
   *
   * @return the total number of search occurrences, or -1 if unknown.
   *
   * @newin{3,10}
   */
  int get_occurrences_count() const;

  
  /** Gets the position of a search occurrence. If the buffer is not already fully scanned, the position may be unknown, and -1 is returned. If 0 is returned,
   * it means that this part of the buffer has already been scanned, and that match_start and match_end don't delimit an occurrence.
   * 
   * @param match_start the start of the occurrence.
   * @param match_end the end of the occurrence.
   * @return the position of the search occurrence. The first occurrence has the position 1 (not 0). Returns 0 if match_start and match_end don't delimit an
   *         occurrence. Returns -1 if the position is not yet known.
   *
   * @newin{3,10}
   */
  int get_occurrence_position(const TextBuffer::iterator& match_start, const TextBuffer::iterator& match_end) const;

  
  /** Synchronous forward search. It is recommended to use the asynchronous functions instead, to not block the user interface. However, if you are sure that
   * the buffer is small, this function is more convenient to use.
   *
   * @param iter start of search.
   * @param match_start return location for start of match, or NULL.
   * @param match_end return location for end of match, or NULL.
   * @return whether a match was found.
   *
   * @newin{3,10}
   */
  bool forward(const TextBuffer::iterator& iter, TextBuffer::iterator& match_start, TextBuffer::iterator& match_end, bool& has_wrapped_around);
  

  /** Asynchronous forward search. See the GAsyncResult documentation to know how to use this function.
   * If the operation is cancelled, the callback will only be called if cancellable was not NULL. gtk_source_search_context_forward_async() takes ownership of
   * cancellable, so you can unref it after calling this function.
   *
   * @param iter start of search.
   * @param cancellable a GCancellable, or NULL.
   * @param callback a GAsyncReadyCallback to call when the operation is finished.
   * @param user_data the data to pass to the callback function.
   *
   * @newin{3,10}
   */
  void forward_async(const TextBuffer::iterator& iter, const Glib::RefPtr<Gio::Cancellable>& cancellable, GAsyncReadyCallback callback, gpointer user_data);

  //gtkmmproc error: gtk_source_search_context_forward_finish2 : method defs lookup failed (1)
  

  /** Synchronous backward search. It is recommended to use the asynchronous functions instead, to not block the user interface. However, if you are sure that the buffer
   * is small, this function is more convenient to use.
   *
   * @param iter start of search.
   * @param match_start return location for start of match, or NULL.
   * @param match_end return location for end of match, or NULL.
   * @return whether a match was found.
   *
   * @newin{3,10}
   */
  bool backward(const TextBuffer::iterator& iter, TextBuffer::iterator& match_start, TextBuffer::iterator& match_end, bool& has_wrapped_around);
  

  /** Asynchronous backward search. See the GAsyncResult documentation to know how to use this function.
   * If the operation is cancelled, the callback will only be called if cancellable was not NULL. gtk_source_search_context_backward_async() takes ownership of
   * cancellable , so you can unref it after calling this function.
   *
   * @param iter start of search.
   * @param cancellable a GCancellable, or NULL.
   * @param callback a GAsyncReadyCallback to call when the operation is finished.
   * @param user_data the data to pass to the callback function.
   *
   * @newin{3,10}
   */
  void backward_async(const TextBuffer::iterator& iter, const Glib::RefPtr<Gio::Cancellable>& cancellable, GAsyncReadyCallback callback, gpointer user_data);

  //gtkmmproc error: gtk_source_search_context_backward_finish2 : method defs lookup failed (1)
  

  //gtkmmproc error: gtk_source_search_context_replace2 : method defs lookup failed (1)
  

  /** Replaces all search matches by another text. It is a synchronous function, so it can block the user interface.
   * For a regular expression replacement, you can check if replace is valid by calling g_regex_check_replacement(). The replace text can contain backreferences; read
   * the g_regex_replace() documentation for more details.
   *
   * @param replace the replacement text.
   * @param replace_length the length of replace in bytes, or -1.
   * @return the number of replaced matches.
   *
   * @newin{3,10}
   */
  unsigned int replace_all(const Glib::ustring& replace, int replace_length);

private:
  //gtkmmproc error: _gtk_source_search_context_update_highlight : method defs lookup failed (1)

public:
  /** The associated GtkSourceBuffer.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Buffer> > property_buffer() const;


  /** Highlight search occurrences.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_highlight() ;

/** Highlight search occurrences.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_highlight() const;

  /** The text style for matches.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Style> > property_match_style() ;

/** The text style for matches.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Style> > property_match_style() const;

  /** Total number of search occurrences.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_occurrences_count() const;


  /** The associated GtkSourceSearchSettings.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SearchSettings> > property_settings() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gsv */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gsv::SearchContext
   */
  
  Glib::RefPtr<Gsv::SearchContext> wrap(GtkSourceSearchContext* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_SEARCHCONTEXT_H */

