// Generated by gmmproc 2.66.8 -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_MARKATTRIBUTES_H
#define _GTKSOURCEVIEWMM_MARKATTRIBUTES_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* markattributes.h
 *
 * Copyright (C) 2010, 2011 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief MarkAttributes class

#include <glibmm/object.h>
#include <glibmm/refptr.h>
//#include <gtksourceviewmm/view.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkSourceMarkAttributes = struct _GtkSourceMarkAttributes;
using GtkSourceMarkAttributesClass = struct _GtkSourceMarkAttributesClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gsv
{ class  MarkAttributes_Class; } // namespace Gsv
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gio
{

class Icon;

} // namespace Gio

namespace Gdk
{

class Pixbuf;
class RGBA;

} // namespace Gdk

namespace Gtk
{

class Widget;

} // namespace Gtk

namespace Gsv
{

class Mark;

// TODO: write docs.

class MarkAttributes : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = MarkAttributes;
  using CppClassType = MarkAttributes_Class;
  using BaseObjectType = GtkSourceMarkAttributes;
  using BaseClassType = GtkSourceMarkAttributesClass;

  // noncopyable
  MarkAttributes(const MarkAttributes&) = delete;
  MarkAttributes& operator=(const MarkAttributes&) = delete;

private:  friend class MarkAttributes_Class;
  static CppClassType markattributes_class_;

protected:
  explicit MarkAttributes(const Glib::ConstructParams& construct_params);
  explicit MarkAttributes(GtkSourceMarkAttributes* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  MarkAttributes(MarkAttributes&& src) noexcept;
  MarkAttributes& operator=(MarkAttributes&& src) noexcept;

  ~MarkAttributes() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceMarkAttributes*       gobj()       { return reinterpret_cast<GtkSourceMarkAttributes*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceMarkAttributes* gobj() const { return reinterpret_cast<GtkSourceMarkAttributes*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceMarkAttributes* gobj_copy();

private:

protected:
  MarkAttributes();
public:
  
  static Glib::RefPtr<MarkAttributes> create();


  /** Stores background color in @a rgba.
   * 
   * @param rgba A Gdk::RGBA.
   * @return Whether background color for @a attributes was set.
   */
  bool get_background(Gdk::RGBA& rgba) const;

  bool is_background_set() const;

  
  /** Sets background color to the one given in @a rgba.
   * 
   * @param rgba A Gdk::RGBA.
   */
  void set_background(const Gdk::RGBA& rgba);

  
  /** Sets a name of an icon to be used as a base for rendered icon.
   * 
   * @param icon_name Name of an icon to be used.
   */
  void set_icon_name(const std::string& icon_name);

  
  /** Gets a name of an icon to be used as a base for rendered icon. Note that the
   * icon name can be <tt>nullptr</tt> if it wasn't set earlier.
   * 
   * @return An icon name. The string belongs to @a attributes and
   * should not be freed.
   */
  std::string get_icon_name() const;

 
  /** Gets a Icon to be used as a base for rendered icon. Note that the icon can
   * be <tt>nullptr</tt> if it wasn't set earlier.
   * 
   * @return An icon. The icon belongs to @a attributes and should
   * not be unreffed.
   */
  Glib::RefPtr<Gio::Icon> get_icon();

  
  /** Gets a Icon to be used as a base for rendered icon. Note that the icon can
   * be <tt>nullptr</tt> if it wasn't set earlier.
   * 
   * @return An icon. The icon belongs to @a attributes and should
   * not be unreffed.
   */
  Glib::RefPtr<const Gio::Icon> get_icon() const;

 
  /** Sets an icon to be used as a base for rendered icon.
   * 
   * @param icon A Icon to be used.
   */
  void set_icon(const Glib::RefPtr<Gio::Icon>& icon);

 
  /** Gets a Gdk::Pixbuf to be used as a base for rendered icon. Note that the
   * pixbuf can be <tt>nullptr</tt> if it wasn't set earlier.
   * 
   * @return A pixbuf. The pixbuf belongs to @a attributes and
   * should not be unreffed.
   */
  Glib::RefPtr<const Gdk::Pixbuf> get_pixbuf() const;

 
  /** Sets a pixbuf to be used as a base for rendered icon.
   * 
   * @param pixbuf A Gdk::Pixbuf to be used.
   */
  void set_pixbuf(const Glib::RefPtr<const Gdk::Pixbuf>& pixbuf);

  
  /** Renders an icon of given size. The base of the icon is set by the last call
   * to one of: set_pixbuf(),
   * set_gicon() or
   * set_icon_name(). @a size cannot be lower than 1.
   * 
   * @param widget Widget of which style settings may be used.
   * @param size Size of the rendered icon.
   * @return A rendered pixbuf. The pixbuf belongs to @a attributes
   * and should not be unreffed.
   */
  Glib::RefPtr<const Gdk::Pixbuf> render_icon(Gtk::Widget* widget, int size) const;

  
  /** Queries for a tooltip by emitting
   * a Gtk::SourceMarkAttributes::signal_query_tooltip_text() signal. The tooltip is a plain
   * text.
   * 
   * @param mark A Gtk::SourceMark.
   * @return A tooltip.
   */
  Glib::ustring get_tooltip_text(const Glib::RefPtr<Mark>& mark) const;

  
  /** Queries for a tooltip by emitting
   * a Gtk::SourceMarkAttributes::signal_query_tooltip_markup() signal. The tooltip may contain
   * a markup.
   * 
   * @param mark A Gtk::SourceMark.
   * @return A tooltip.
   */
  Glib::ustring get_tooltip_markup(const Glib::RefPtr<Mark>& mark) const;

  /** The background.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::RGBA > property_background() ;

/** The background.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::RGBA > property_background() const;


  /** The pixbuf.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_pixbuf() ;

/** The pixbuf.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> > property_pixbuf() const;


  /** The icon name.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< std::string > property_icon_name() ;

/** The icon name.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::string > property_icon_name() const;


  /** The GIcon.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> > property_gicon() ;

/** The GIcon.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> > property_gicon() const;


  /**
   * @par Slot Prototype:
   * <tt>Glib::ustring on_my_%query_tooltip_text(const Glib::RefPtr<Mark>& mark)</tt>
   *
   * Flags: Run Last
   *
   * The code should connect to this signal to provide a tooltip for given
   *  @a mark. The tooltip should be just a plain text.
   * 
   * @param mark The Gtk::SourceMark.
   * @return A tooltip.
   */

  Glib::SignalProxy< Glib::ustring,const Glib::RefPtr<Mark>& > signal_query_tooltip_text();


  /**
   * @par Slot Prototype:
   * <tt>Glib::ustring on_my_%query_tooltip_markup(const Glib::RefPtr<Mark>& mark)</tt>
   *
   * Flags: Run Last
   *
   * The code should connect to this signal to provide a tooltip for given
   *  @a mark. The tooltip can contain a markup.
   * 
   * @param mark The Gtk::SourceMark.
   * @return A tooltip.
   */

  Glib::SignalProxy< Glib::ustring,const Glib::RefPtr<Mark>& > signal_query_tooltip_markup();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gsv


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gsv::MarkAttributes
   */
  
  Glib::RefPtr<Gsv::MarkAttributes> wrap(GtkSourceMarkAttributes* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_MARKATTRIBUTES_H */

