"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMissingPropsDiagnostics = getMissingPropsDiagnostics;
const language_core_1 = require("@vue/language-core");
function getMissingPropsDiagnostics(fileName) {
    const { typescript: ts, language, languageService, asScriptId } = this;
    const volarFile = language.scripts.get(asScriptId(fileName));
    if (!(volarFile?.generated?.root instanceof language_core_1.VueVirtualCode)) {
        return;
    }
    const vueCode = volarFile.generated.root;
    const program = languageService.getProgram();
    const sourceFile = program.getSourceFile(vueCode.fileName);
    if (!sourceFile) {
        return;
    }
    const checker = program.getTypeChecker();
    ts.forEachChild(sourceFile, function visit(node) {
        if (ts.isVariableDeclaration(node)
            && node.initializer
            && ts.isCallExpression(node.initializer)
            && ts.isIdentifier(node.initializer.expression)
            && /^__VLS_\d+$/.test(node.initializer.expression.text)) {
            const firstArg = node.initializer.arguments[0];
            const type = checker.getTypeAtLocation(firstArg);
            const contextualType = checker.getContextualType(firstArg);
            if (contextualType) {
                const subtype = contextualType.isUnion()
                    ? contextualType.types.find(subtype => checker.isTypeAssignableTo(subtype, type))
                    : contextualType;
                void subtype;
            }
        }
        else {
            ts.forEachChild(node, visit);
        }
    });
    return undefined;
}
//# sourceMappingURL=getMissingPropsDiagnostics.js.map