"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefineSlots = getDefineSlots;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getDefineSlots(fileName) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof language_core_1.VueVirtualCode)) {
        return;
    }
    const vueCode = volarFile.generated.root;
    const slots = (0, utils_1.getTypeAliasType)(ts, languageService, vueCode, '__VLS_Slots');
    return slots?.type.getProperties().map(prop => prop.getName());
}
//# sourceMappingURL=getDefineSlots.js.map