"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentDirectives = getComponentDirectives;
const utils_1 = require("./utils");
const builtInDirectives = new Set([
    'vBind',
    'vIf',
    'vOn',
    'vOnce',
    'vShow',
    'vSlot',
]);
function getComponentDirectives(ts, program, fileName) {
    const directives = (0, utils_1.getVariableType)(ts, program, fileName, '__VLS_directives');
    if (!directives) {
        return [];
    }
    return directives.type.getProperties()
        .map(({ name }) => name)
        .filter(name => name.startsWith('v') && name.length >= 2 && name[1] === name[1].toUpperCase())
        .filter(name => !builtInDirectives.has(name));
}
//# sourceMappingURL=getComponentDirectives.js.map