"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVariableProperties = getVariableProperties;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getVariableProperties(fileName, variableName) {
    const { typescript: ts, language, languageService, asScriptId } = this;
    const volarFile = language.scripts.get(asScriptId(fileName));
    if (!(volarFile?.generated?.root instanceof language_core_1.VueVirtualCode)) {
        return;
    }
    const vueCode = volarFile.generated.root;
    const variable = (0, utils_1.getVariableType)(ts, languageService, vueCode, variableName);
    return variable?.type.getProperties().map(prop => prop.name);
}
//# sourceMappingURL=getVariableProperties.js.map