/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.NetworkChannel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;

public abstract class AbstractJsseEndpoint<S, U>
extends AbstractEndpoint<S, U> {
    private String sslImplementationName = null;
    private int sniParseLimit = 65536;
    private SSLImplementation sslImplementation = null;

    public String getSslImplementationName() {
        return this.sslImplementationName;
    }

    public void setSslImplementationName(String string) {
        this.sslImplementationName = string;
    }

    public SSLImplementation getSslImplementation() {
        return this.sslImplementation;
    }

    public int getSniParseLimit() {
        return this.sniParseLimit;
    }

    public void setSniParseLimit(int n) {
        this.sniParseLimit = n;
    }

    protected void initialiseSsl() throws Exception {
        if (this.isSSLEnabled()) {
            this.sslImplementation = SSLImplementation.getInstance(this.getSslImplementationName());
            for (SSLHostConfig sSLHostConfig : this.sslHostConfigs.values()) {
                this.createSSLContext(sSLHostConfig);
            }
            if (this.sslHostConfigs.get(this.getDefaultSSLHostConfigName()) == null) {
                throw new IllegalArgumentException(sm.getString("endpoint.noSslHostConfig", new Object[]{this.getDefaultSSLHostConfigName(), this.getName()}));
            }
        }
    }

    @Override
    protected void createSSLContext(SSLHostConfig sSLHostConfig) throws IllegalArgumentException {
        boolean bl = true;
        for (SSLHostConfigCertificate sSLHostConfigCertificate : sSLHostConfig.getCertificates(true)) {
            SSLUtil sSLUtil = this.sslImplementation.getSSLUtil(sSLHostConfigCertificate);
            if (bl) {
                bl = false;
                sSLHostConfig.setEnabledProtocols(sSLUtil.getEnabledProtocols());
                sSLHostConfig.setEnabledCiphers(sSLUtil.getEnabledCiphers());
            }
            SSLContext sSLContext = sSLHostConfigCertificate.getSslContext();
            SSLContext sSLContext2 = sSLHostConfigCertificate.getSslContextGenerated();
            if (sSLContext == null || sSLContext == sSLContext2) {
                try {
                    sSLContext = sSLUtil.createSSLContext(this.negotiableProtocols);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(exception.getMessage(), exception);
                }
                sSLHostConfigCertificate.setSslContextGenerated(sSLContext);
            }
            this.logCertificate(sSLHostConfigCertificate);
        }
    }

    protected SSLEngine createSSLEngine(String string, List<Cipher> list, List<String> list2) {
        SSLHostConfig sSLHostConfig = this.getSSLHostConfig(string);
        SSLHostConfigCertificate sSLHostConfigCertificate = this.selectCertificate(sSLHostConfig, list);
        SSLContext sSLContext = sSLHostConfigCertificate.getSslContext();
        if (sSLContext == null) {
            throw new IllegalStateException(sm.getString("endpoint.jsse.noSslContext", new Object[]{string}));
        }
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        sSLEngine.setUseClientMode(false);
        sSLEngine.setEnabledCipherSuites(sSLHostConfig.getEnabledCiphers());
        sSLEngine.setEnabledProtocols(sSLHostConfig.getEnabledProtocols());
        SSLParameters sSLParameters = sSLEngine.getSSLParameters();
        sSLParameters.setUseCipherSuitesOrder(sSLHostConfig.getHonorCipherOrder());
        if (JreCompat.isAlpnSupported() && list2 != null && list2.size() > 0 && this.negotiableProtocols.size() > 0) {
            ArrayList arrayList = new ArrayList(this.negotiableProtocols);
            arrayList.retainAll(list2);
            if (arrayList.size() > 0) {
                String[] stringArray = arrayList.toArray(new String[0]);
                JreCompat.getInstance().setApplicationProtocols(sSLParameters, stringArray);
            }
        }
        switch (sSLHostConfig.getCertificateVerification()) {
            case NONE: {
                sSLParameters.setNeedClientAuth(false);
                sSLParameters.setWantClientAuth(false);
                break;
            }
            case OPTIONAL: 
            case OPTIONAL_NO_CA: {
                sSLParameters.setWantClientAuth(true);
                break;
            }
            case REQUIRED: {
                sSLParameters.setNeedClientAuth(true);
            }
        }
        sSLEngine.setSSLParameters(sSLParameters);
        return sSLEngine;
    }

    private SSLHostConfigCertificate selectCertificate(SSLHostConfig sSLHostConfig, List<Cipher> list) {
        Set<SSLHostConfigCertificate> set = sSLHostConfig.getCertificates(true);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        LinkedHashSet<Cipher> linkedHashSet = sSLHostConfig.getCipherList();
        ArrayList<Cipher> arrayList = new ArrayList<Cipher>();
        if (sSLHostConfig.getHonorCipherOrder()) {
            arrayList.addAll(linkedHashSet);
            arrayList.retainAll(list);
        } else {
            arrayList.addAll(list);
            arrayList.retainAll(linkedHashSet);
        }
        for (Cipher cipher : arrayList) {
            for (SSLHostConfigCertificate sSLHostConfigCertificate : set) {
                if (!sSLHostConfigCertificate.getType().isCompatibleWith(cipher.getAu())) continue;
                return sSLHostConfigCertificate;
            }
        }
        return set.iterator().next();
    }

    @Override
    public boolean isAlpnSupported() {
        SSLImplementation sSLImplementation;
        if (!this.isSSLEnabled()) {
            return false;
        }
        try {
            sSLImplementation = SSLImplementation.getInstance(this.getSslImplementationName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return sSLImplementation.isAlpnSupported();
    }

    @Override
    public void unbind() throws Exception {
        for (SSLHostConfig sSLHostConfig : this.sslHostConfigs.values()) {
            for (SSLHostConfigCertificate sSLHostConfigCertificate : sSLHostConfig.getCertificates(true)) {
                sSLHostConfigCertificate.setSslContextGenerated(null);
            }
        }
    }

    protected abstract NetworkChannel getServerSocket();

    @Override
    protected final InetSocketAddress getLocalAddress() throws IOException {
        NetworkChannel networkChannel = this.getServerSocket();
        if (networkChannel == null) {
            return null;
        }
        SocketAddress socketAddress = networkChannel.getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)socketAddress;
        }
        return null;
    }

    @Override
    protected void setDefaultSslHostConfig(SSLHostConfig sSLHostConfig) {
    }
}

