/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.measurement;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDMeasureDictionary;

public class PDViewportDictionary
implements COSObjectable {
    public static final String TYPE = "Viewport";
    private COSDictionary viewportDictionary;

    public PDViewportDictionary() {
        this.viewportDictionary = new COSDictionary();
    }

    public PDViewportDictionary(COSDictionary dictionary) {
        this.viewportDictionary = dictionary;
    }

    @Override
    public COSBase getCOSObject() {
        return this.viewportDictionary;
    }

    public COSDictionary getDictionary() {
        return this.viewportDictionary;
    }

    public String getType() {
        return TYPE;
    }

    public PDRectangle getBBox() {
        COSArray bbox = (COSArray)this.getDictionary().getDictionaryObject("BBox");
        if (bbox != null) {
            return new PDRectangle(bbox);
        }
        return null;
    }

    public void setBBox(PDRectangle rectangle) {
        this.getDictionary().setItem("BBox", (COSObjectable)rectangle);
    }

    public String getName() {
        return this.getDictionary().getNameAsString(COSName.NAME);
    }

    public void setName(String name) {
        this.getDictionary().setName(COSName.NAME, name);
    }

    public PDMeasureDictionary getMeasure() {
        COSDictionary measure = (COSDictionary)this.getDictionary().getDictionaryObject("Measure");
        if (measure != null) {
            return new PDMeasureDictionary(measure);
        }
        return null;
    }

    public void setMeasure(PDMeasureDictionary measure) {
        this.getDictionary().setItem("Measure", (COSObjectable)measure);
    }
}

