/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.lang.reflect.Array;
import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.generic.CommonErrors$;
import scala.collection.generic.DefaultSerializable;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayBufferView;
import scala.collection.mutable.Growable;
import scala.collection.mutable.IndexedBuffer;

public class ArrayBuffer<A>
extends AbstractBuffer<A>
implements StrictOptimizedSeqOps<A, ArrayBuffer, ArrayBuffer<A>>,
DefaultSerializable,
IndexedBuffer<A> {
    private transient int mutationCount = 0;
    private Object[] array;
    private int size0;

    /*
     * WARNING - void declaration
     */
    @Override
    public Object distinctBy(Function1 f) {
        void var1_1;
        return StrictOptimizedSeqOps.distinctBy$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object prepended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.prepended$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object appended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.appended$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object appendedAll(IterableOnce suffix) {
        void var1_1;
        return StrictOptimizedSeqOps.appendedAll$(this, (IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<ArrayBuffer<A>, ArrayBuffer<A>> partition(Function1<A, Object> p) {
        void var1_1;
        return StrictOptimizedIterableOps.partition$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <A1, A2> Tuple2<ArrayBuffer<A1>, ArrayBuffer<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        void var1_1;
        return StrictOptimizedIterableOps.unzip$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object map(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.map$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return StrictOptimizedIterableOps.filterImpl$(this, (Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object dropRight(int n) {
        void var1_1;
        return StrictOptimizedIterableOps.dropRight$(this, (int)var1_1);
    }

    @Override
    public Iterator<A> iterator() {
        return IndexedSeqOps.iterator$(this);
    }

    @Override
    public Iterator<A> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public Iterable<A> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object take(int n) {
        void var1_1;
        return IndexedSeqOps.take$(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object drop(int n) {
        void var1_1;
        return IndexedSeqOps.drop$(this, (int)var1_1);
    }

    @Override
    public Object reverse() {
        return IndexedSeqOps.reverse$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object slice(int from, int until) {
        void var2_2;
        void var1_1;
        return IndexedSeqOps.slice$(this, (int)var1_1, (int)var2_2);
    }

    @Override
    public A head() {
        return (A)IndexedSeqOps.head$(this);
    }

    @Override
    public Option<A> headOption() {
        return IndexedSeqOps.headOption$(this);
    }

    @Override
    public A last() {
        return (A)IndexedSeqOps.last$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lengthCompare(int len) {
        void var1_1;
        return IndexedSeqOps.lengthCompare$(this, (int)var1_1);
    }

    public Object[] array() {
        return this.array;
    }

    /*
     * WARNING - void declaration
     */
    public void array_$eq(Object[] x$1) {
        void var1_1;
        this.array = var1_1;
    }

    public int size0() {
        return this.size0;
    }

    /*
     * WARNING - void declaration
     */
    public void size0_$eq(int x$1) {
        void var1_1;
        this.size0 = var1_1;
    }

    @Override
    public int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    /*
     * WARNING - void declaration
     */
    public void ensureSize(int n) {
        void var1_1;
        this.array_$eq(ArrayBuffer$.MODULE$.scala$collection$mutable$ArrayBuffer$$ensureSize(this.array(), this.size0(), (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void sizeHint(int size) {
        if (size > this.length() && size > 0) {
            void var1_1;
            this.ensureSize((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reduceToSize(int n) {
        void var1_1;
        ++this.mutationCount;
        Arrays.fill(this.array(), n, this.size0(), null);
        this.size0_$eq((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public A apply(int n) {
        void var1_1;
        int checkWithinBounds_hi = n + 1;
        if (n < 0) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(n, this.size0() - 1);
        }
        if (checkWithinBounds_hi > this.size0()) {
            void var2_2;
            throw CommonErrors$.MODULE$.indexOutOfBounds((int)(var2_2 - true), this.size0() - 1);
        }
        return (A)this.array()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(int index, A elem) {
        void var2_2;
        int checkWithinBounds_hi = index + 1;
        if (index < 0) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(index, this.size0() - 1);
        }
        if (checkWithinBounds_hi > this.size0()) {
            void var3_3;
            throw CommonErrors$.MODULE$.indexOutOfBounds((int)(var3_3 - true), this.size0() - 1);
        }
        ++this.mutationCount;
        this.array()[var1_1] = var2_2;
    }

    @Override
    public int length() {
        return this.size0();
    }

    @Override
    public ArrayBufferView<A> view() {
        ArrayBuffer arrayBuffer = this;
        return new ArrayBufferView(arrayBuffer, () -> $this.mutationCount);
    }

    @Override
    public SeqFactory<ArrayBuffer> iterableFactory() {
        return ArrayBuffer$.MODULE$;
    }

    @Override
    public void clear() {
        this.reduceToSize(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayBuffer<A> addOne(A elem) {
        void var1_1;
        void var2_2;
        ++this.mutationCount;
        int newSize = this.size0() + 1;
        this.ensureSize(newSize);
        this.size0_$eq((int)var2_2);
        ArrayBuffer arrayBuffer = this;
        arrayBuffer.update(arrayBuffer.size0() - 1, var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayBuffer<A> addAll(IterableOnce<A> elems) {
        if (elems instanceof ArrayBuffer) {
            int elemsLength = (elems = (ArrayBuffer)elems).size0();
            if (elemsLength > 0) {
                void var2_2;
                ++this.mutationCount;
                ArrayBuffer arrayBuffer = this;
                arrayBuffer.ensureSize(arrayBuffer.size0() + elemsLength);
                Array$.MODULE$.copy(elems.array(), 0, this.array(), this.length(), elemsLength);
                ArrayBuffer arrayBuffer2 = this;
                arrayBuffer2.size0_$eq(arrayBuffer2.length() + var2_2);
            }
        } else {
            void var1_1;
            Growable.addAll$(this, (IterableOnce)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public A remove(int index) {
        void var2_3;
        void var1_1;
        void var3_2;
        int checkWithinBounds_hi = index + 1;
        if (index < 0) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(index, this.size0() - 1);
        }
        if (checkWithinBounds_hi > this.size0()) {
            throw CommonErrors$.MODULE$.indexOutOfBounds((int)(var3_2 - true), this.size0() - 1);
        }
        A res = this.apply(index);
        Array$.MODULE$.copy(this.array(), (int)var3_2, this.array(), (int)var1_1, this.size0() - var3_2);
        ArrayBuffer arrayBuffer = this;
        arrayBuffer.reduceToSize(arrayBuffer.size0() - 1);
        return var2_3;
    }

    @Override
    public String stringPrefix() {
        return "ArrayBuffer";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> int copyToArray(Object xs, int start, int len) {
        void var3_3;
        void elemsToCopyToArray_destLen;
        int n = Array.getLength(xs);
        int elemsToCopyToArray_srcLen = this.length();
        int copied = Math.max(Math.min(Math.min(len, elemsToCopyToArray_srcLen), (int)(elemsToCopyToArray_destLen - start)), 0);
        if (copied > 0) {
            void var2_2;
            void var1_1;
            Array$.MODULE$.copy(this.array(), 0, var1_1, (int)var2_2, copied);
        }
        return (int)var3_3;
    }

    @Override
    public <B> B foldLeft(B z, Function2<B, A, B> op) {
        B b = z;
        int foldl_end = this.length();
        int foldl_start = 0;
        B foldl_z;
        while (foldl_start != foldl_end) {
            foldl_z = op.apply(foldl_z, this.array()[foldl_start]);
            ++foldl_start;
        }
        return foldl_z;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> B reduceLeft(Function2<B, A, B> op) {
        if (this.length() > 0) {
            Object object = this.array()[0];
            int foldl_end = this.length();
            int foldl_start = 1;
            while (true) {
                B foldl_z;
                if (foldl_start == foldl_end) {
                    return foldl_z;
                }
                foldl_z = op.apply(foldl_z, this.array()[foldl_start]);
                ++foldl_start;
            }
        }
        if (this.length() > 0) {
            Object reduceLeft_foldl_z;
            Object foldl_z = reduceLeft_foldl_z = this.apply(0);
            int reduceLeft_foldl_loop$1_end = this.length();
            int reduceLeft_foldl_loop$1_at = 1;
            while (true) {
                B reduceLeft_foldl_loop$1_acc;
                if (reduceLeft_foldl_loop$1_at == reduceLeft_foldl_loop$1_end) {
                    return reduceLeft_foldl_loop$1_acc;
                }
                reduceLeft_foldl_loop$1_acc = op.apply(reduceLeft_foldl_loop$1_acc, this.apply(reduceLeft_foldl_loop$1_at));
                ++reduceLeft_foldl_loop$1_at;
            }
        }
        if (this.knownSize() == 0) {
            throw new UnsupportedOperationException("empty.reduceLeft");
        }
        Iterator reduceLeft_reduceLeftIterator_it = this.iterator();
        if (reduceLeft_reduceLeftIterator_it.hasNext()) {
            void var3_6;
            Object reduceLeft_reduceLeftIterator_acc = reduceLeft_reduceLeftIterator_it.next();
            while (reduceLeft_reduceLeftIterator_it.hasNext()) {
                reduceLeft_reduceLeftIterator_acc = op.apply(reduceLeft_reduceLeftIterator_acc, reduceLeft_reduceLeftIterator_it.next());
            }
            return var3_6;
        }
        throw new UnsupportedOperationException("empty.reduceLeft");
    }

    /*
     * WARNING - void declaration
     */
    public ArrayBuffer(Object[] initialElements, int initialSize) {
        void var2_2;
        void var1_1;
        this.array = var1_1;
        this.size0 = var2_2;
    }

    public ArrayBuffer() {
        this(new Object[16], 0);
    }

    /*
     * WARNING - void declaration
     */
    public ArrayBuffer(int initialSize) {
        this(new Object[Math.max((int)var1_1, 1)], 0);
        void var1_1;
    }
}

