/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;

public class EContentAdapter
extends AdapterImpl {
    public void notifyChanged(Notification notification) {
        this.selfAdapt(notification);
        super.notifyChanged(notification);
    }

    protected void selfAdapt(Notification notification) {
        EReference eReference;
        Object feature;
        Object notifier = notification.getNotifier();
        if (notifier instanceof ResourceSet) {
            if (notification.getFeatureID(ResourceSet.class) == 0) {
                this.handleContainment(notification);
            }
        } else if (notifier instanceof Resource) {
            if (notification.getFeatureID(Resource.class) == 2) {
                this.handleContainment(notification);
            }
        } else if (notifier instanceof EObject && (feature = notification.getFeature()) instanceof EReference && (eReference = (EReference)feature).isContainment()) {
            this.handleContainment(notification);
        }
    }

    protected void handleContainment(Notification notification) {
        switch (notification.getEventType()) {
            case 9: {
                Notifier oldValue = (Notifier)notification.getOldValue();
                if (!oldValue.eAdapters().contains(this)) break;
                this.removeAdapter(oldValue);
                Notifier newValue = (Notifier)notification.getNewValue();
                this.addAdapter(newValue);
                break;
            }
            case 2: {
                Notifier newValue;
                Object oldValue = notification.getOldValue();
                if (oldValue == Boolean.TRUE || oldValue == Boolean.FALSE) break;
                if (oldValue != null) {
                    this.removeAdapter((Notifier)oldValue, false, true);
                }
                if ((newValue = (Notifier)notification.getNewValue()) == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 1: {
                Notifier newValue;
                Notifier oldValue = (Notifier)notification.getOldValue();
                if (oldValue != null) {
                    this.removeAdapter(oldValue, false, true);
                }
                if ((newValue = (Notifier)notification.getNewValue()) == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 3: {
                Notifier newValue = (Notifier)notification.getNewValue();
                if (newValue == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                for (Notifier newValue : newValues) {
                    this.addAdapter(newValue);
                }
                break;
            }
            case 4: {
                Notifier oldValue = (Notifier)notification.getOldValue();
                if (oldValue == null) break;
                boolean checkContainer = notification.getNotifier() instanceof Resource;
                boolean checkResource = notification.getFeature() != null;
                this.removeAdapter(oldValue, checkContainer, checkResource);
                break;
            }
            case 6: {
                boolean checkContainer = notification.getNotifier() instanceof Resource;
                boolean checkResource = notification.getFeature() != null;
                Collection oldValues = (Collection)notification.getOldValue();
                for (Notifier oldContentValue : oldValues) {
                    this.removeAdapter(oldContentValue, checkContainer, checkResource);
                }
                break;
            }
        }
    }

    public void setTarget(Notifier target) {
        if (target instanceof EObject) {
            this.setTarget((EObject)target);
        } else if (target instanceof Resource) {
            this.setTarget((Resource)target);
        } else if (target instanceof ResourceSet) {
            this.setTarget((ResourceSet)target);
        } else {
            this.basicSetTarget(target);
        }
    }

    protected void basicSetTarget(Notifier target) {
        super.setTarget(target);
    }

    protected void setTarget(EObject target) {
        this.basicSetTarget(target);
        Iterator i = this.resolve() ? target.eContents().iterator() : ((InternalEList)target.eContents()).basicIterator();
        while (i.hasNext()) {
            Notifier notifier = (Notifier)i.next();
            this.addAdapter(notifier);
        }
    }

    protected void setTarget(Resource target) {
        this.basicSetTarget(target);
        EList<EObject> contents = target.getContents();
        int i = 0;
        int size = contents.size();
        while (i < size) {
            Notifier notifier = (Notifier)contents.get(i);
            this.addAdapter(notifier);
            ++i;
        }
    }

    protected void setTarget(ResourceSet target) {
        this.basicSetTarget(target);
        EList<Resource> resources = target.getResources();
        int i = 0;
        while (i < resources.size()) {
            Notifier notifier = (Notifier)resources.get(i);
            this.addAdapter(notifier);
            ++i;
        }
    }

    public void unsetTarget(Notifier target) {
        this.unsetTarget((Object)target);
    }

    protected void basicUnsetTarget(Notifier target) {
        super.unsetTarget(target);
    }

    @Deprecated
    protected void unsetTarget(Object target) {
        if (target instanceof EObject) {
            this.unsetTarget((EObject)target);
        } else if (target instanceof Resource) {
            this.unsetTarget((Resource)target);
        } else if (target instanceof ResourceSet) {
            this.unsetTarget((ResourceSet)target);
        } else {
            this.basicUnsetTarget((Notifier)target);
        }
    }

    protected void unsetTarget(EObject target) {
        this.basicUnsetTarget(target);
        Iterator i = this.resolve() ? target.eContents().iterator() : ((InternalEList)target.eContents()).basicIterator();
        while (i.hasNext()) {
            Notifier notifier = (Notifier)i.next();
            this.removeAdapter(notifier, false, true);
        }
    }

    protected void unsetTarget(Resource target) {
        this.basicUnsetTarget(target);
        EList<EObject> contents = target.getContents();
        int i = 0;
        int size = contents.size();
        while (i < size) {
            Notifier notifier = (Notifier)contents.get(i);
            this.removeAdapter(notifier, true, false);
            ++i;
        }
    }

    protected void unsetTarget(ResourceSet target) {
        this.basicUnsetTarget(target);
        EList<Resource> resources = target.getResources();
        int i = 0;
        while (i < resources.size()) {
            Notifier notifier = (Notifier)resources.get(i);
            this.removeAdapter(notifier, false, false);
            ++i;
        }
    }

    protected void addAdapter(Notifier notifier) {
        EList<Adapter> eAdapters = notifier.eAdapters();
        if (!eAdapters.contains(this)) {
            eAdapters.add(this);
        }
    }

    protected void removeAdapter(Notifier notifier, boolean checkContainer, boolean checkResource) {
        if (checkContainer || checkResource) {
            InternalEObject eInternalContainer;
            Resource.Internal eDirectResource;
            InternalEObject internalEObject = (InternalEObject)notifier;
            if (checkResource && (eDirectResource = internalEObject.eDirectResource()) != null && eDirectResource.eAdapters().contains(this)) {
                return;
            }
            if (checkContainer && (eInternalContainer = internalEObject.eInternalContainer()) != null && eInternalContainer.eAdapters().contains(this)) {
                return;
            }
        }
        this.removeAdapter(notifier);
    }

    protected void removeAdapter(Notifier notifier) {
        notifier.eAdapters().remove(this);
    }

    protected boolean resolve() {
        return true;
    }
}

