/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.io.IOException;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandSpriteStdlib
extends SingleLineCommand2<TitledDiagram> {
    public static final CommandSpriteStdlib ME = new CommandSpriteStdlib();

    private CommandSpriteStdlib() {
        super(CommandSpriteStdlib.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandSpriteStdlib.class.getName(), RegexLeaf.start(), new RegexLeaf("sprite"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\$"), new RegexLeaf(1, "NAME", "([-%pLN_]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(2, "STDLIB", "#([^#]+)#([^%s]+)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(TitledDiagram system, LineLocation location, RegexResult arg, ParserPass currentPass) {
        try {
            Stdlib lib = Stdlib.retrieve(arg.get("STDLIB", 0));
            String exportedName = arg.get("STDLIB", 1);
            String name = arg.get("NAME", 0);
            Sprite sprite = lib.readSprite(exportedName);
            system.addSprite(name, sprite);
        }
        catch (IOException e) {
            return CommandExecutionResult.error("Cannot read sprite " + e.toString());
        }
        return CommandExecutionResult.ok();
    }
}

