/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.syntax;

import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.syntax.SyntaxResult;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.LineLocationImpl;

public class SyntaxChecker {
    public static SyntaxResult checkSyntax(List<String> source) {
        StringBuilder sb = new StringBuilder();
        for (String s : source) {
            sb.append(s);
            sb.append("\n");
        }
        return SyntaxChecker.checkSyntax(sb.toString());
    }

    public static SyntaxResult checkSyntax(String source) {
        OptionFlags.getInstance().setQuiet(true);
        SyntaxResult result = new SyntaxResult();
        if (!source.startsWith("@startuml\n")) {
            result.setError(true);
            result.setLineLocation(new LineLocationImpl("", null).oneLineRead());
            result.addErrorText("No @startuml/@enduml found");
            return result;
        }
        if (!source.endsWith("@enduml\n") && !source.endsWith("@enduml")) {
            result.setError(true);
            result.setLineLocation(SyntaxChecker.lastLineNumber(source));
            result.addErrorText("No @enduml found");
            return result;
        }
        SourceStringReader sourceStringReader = new SourceStringReader(Defines.createEmpty(), source, Collections.emptyList());
        List<BlockUml> blocks = sourceStringReader.getBlocks();
        if (blocks.size() == 0) {
            result.setError(true);
            result.setLineLocation(SyntaxChecker.lastLineNumber(source));
            result.addErrorText("No @enduml found");
            return result;
        }
        Diagram system = blocks.get(0).getDiagram();
        result.setCmapData(system.hasUrl());
        if (system instanceof UmlDiagram) {
            result.setUmlDiagramType(((UmlDiagram)system).getUmlDiagramType());
            result.setDescription(system.getDescription().getDescription());
        } else if (system instanceof PSystemError) {
            result.setError(true);
            PSystemError sys = (PSystemError)system;
            result.setLineLocation(sys.getLineLocation());
            result.setSystemError(sys);
            for (ErrorUml er : sys.getErrorsUml()) {
                result.addErrorText(er.getError());
            }
        } else {
            result.setDescription(system.getDescription().getDescription());
        }
        return result;
    }

    public static SyntaxResult checkSyntaxFair(String source) {
        SyntaxResult result = new SyntaxResult();
        SourceStringReader sourceStringReader = new SourceStringReader(Defines.createEmpty(), source, Collections.emptyList());
        List<BlockUml> blocks = sourceStringReader.getBlocks();
        if (blocks.size() == 0) {
            result.setError(true);
            result.setLineLocation(SyntaxChecker.lastLineNumber(source));
            result.addErrorText("No @enduml found");
            return result;
        }
        Diagram system = blocks.get(0).getDiagram();
        result.setCmapData(system.hasUrl());
        if (system instanceof UmlDiagram) {
            result.setUmlDiagramType(((UmlDiagram)system).getUmlDiagramType());
            result.setDescription(system.getDescription().getDescription());
        } else if (system instanceof PSystemError) {
            result.setError(true);
            PSystemError sys = (PSystemError)system;
            result.setLineLocation(sys.getLineLocation());
            for (ErrorUml er : sys.getErrorsUml()) {
                result.addErrorText(er.getError());
            }
            result.setSystemError(sys);
        } else {
            result.setDescription(system.getDescription().getDescription());
        }
        return result;
    }

    private static LineLocation lastLineNumber(String source) {
        LineLocationImpl result = new LineLocationImpl("", null).oneLineRead();
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) != '\n') continue;
            result = result.oneLineRead();
        }
        return result;
    }
}

