/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.atom;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.atom.AtomImgSvg;
import net.sourceforge.plantuml.klimt.creole.legacy.AtomTextUtils;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.ImgValign;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TileImageSvg;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.Base64Coder;

public class AtomImg
extends AbstractAtom
implements Atom {
    public static final String DATA_IMAGE_PNG_BASE64 = "data:image/png;base64,";
    public static final String DATA_IMAGE_PNG_SPM = "data:image/png;spm ";
    private static final String DATA_IMAGE_SVG_BASE64 = "data:image/svg+xml;base64,";
    private final BufferedImage image;
    private final double scale;
    private final Url url;
    private final String rawFileName;

    private AtomImg(BufferedImage image, double scale, Url url, String rawFileName) {
        this.image = image;
        this.scale = scale;
        this.url = url;
        this.rawFileName = rawFileName;
    }

    public static Atom createQrcode(String flash, double scale) {
        BufferedImage im = null;
        im = FlashCodeFactory.getFlashCodeUtils().exportFlashcode(flash, Color.BLACK, Color.WHITE);
        if (im == null) {
            im = new BufferedImage(10, 10, 1);
        }
        return new AtomImg(new UImage(new PixelImage(im, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(scale).getImage(1.0), 1.0, null, null);
    }

    public static Atom create(String src, ImgValign valign, int vspace, double scale, Url url) {
        UFont font = UFont.monospaced(14);
        FontConfiguration fc = FontConfiguration.blackBlueTrue(font);
        if (src.startsWith(DATA_IMAGE_PNG_SPM)) {
            String data = src.substring(DATA_IMAGE_PNG_SPM.length(), src.length());
            int x = data.indexOf(47);
            if (x == -1) {
                return AtomTextUtils.createLegacy("ERROR DATA IMAGE", fc);
            }
            try {
                Stdlib lib = Stdlib.retrieve(data.substring(0, x));
                int num = Integer.parseInt(data.substring(x + 1));
                BufferedImage image = lib.readDataImagePng(num).getNow();
                return new AtomImg(image, scale, url, null);
            }
            catch (Exception e) {
                return AtomTextUtils.createLegacy("ERROR " + e.toString(), fc);
            }
        }
        if (src.startsWith(DATA_IMAGE_PNG_BASE64)) {
            String data = src.substring(DATA_IMAGE_PNG_BASE64.length(), src.length());
            try {
                byte[] bytes = Base64Coder.decode(data);
                return AtomImg.buildRasterFromData(src, fc, bytes, scale, url);
            }
            catch (Exception e) {
                return AtomTextUtils.createLegacy("ERROR " + e.toString(), fc);
            }
        }
        if (src.startsWith(DATA_IMAGE_SVG_BASE64)) {
            String data = src.substring(DATA_IMAGE_SVG_BASE64.length(), src.length());
            try {
                byte[] bytes = Base64Coder.decode(data);
                String tmp = new String(bytes);
                return new AtomImgSvg(new TileImageSvg(tmp, scale));
            }
            catch (Exception e) {
                return AtomTextUtils.createLegacy("ERROR " + e.toString(), fc);
            }
        }
        try {
            if (src.startsWith("http:") || src.startsWith("https:")) {
                if (src.endsWith(".svg")) {
                    return AtomImg.buildSvgFromUrl(src, fc, SURL.create(src), scale, url);
                }
                return AtomImg.buildRasterFromUrl(src, fc, SURL.create(src), scale, url);
            }
            SFile f = FileSystem.getInstance().getFile(src);
            if (!f.exists()) {
                if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                    return AtomTextUtils.createLegacy("(File not found: " + f.getPrintablePath() + ")", fc);
                }
                return AtomTextUtils.createLegacy("(Cannot decode)", fc);
            }
            if (f.getName().endsWith(".svg")) {
                String tmp = FileUtils.readSvg(f);
                if (tmp == null) {
                    return AtomTextUtils.createLegacy("(Cannot decode)", fc);
                }
                return new AtomImgSvg(new TileImageSvg(tmp, scale));
            }
            BufferedImage read = f.readRasterImageFromFile();
            if (read == null) {
                if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                    return AtomTextUtils.createLegacy("(Cannot decode: " + f.getPrintablePath() + ")", fc);
                }
                return AtomTextUtils.createLegacy("(Cannot decode)", fc);
            }
            return new AtomImg(f.readRasterImageFromFile(), scale, url, src);
        }
        catch (IOException e) {
            Logme.error(e);
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                return AtomTextUtils.createLegacy("ERROR " + e.toString(), fc);
            }
            return AtomTextUtils.createLegacy("ERROR", fc);
        }
    }

    private static Atom buildRasterFromData(String source, FontConfiguration fc, byte[] data, double scale, Url url) throws IOException {
        BufferedImage read = SImageIO.read(data);
        if (read == null) {
            return AtomTextUtils.createLegacy("(Cannot decode: " + source + ")", fc);
        }
        return new AtomImg(read, scale, url, null);
    }

    private static Atom buildRasterFromUrl(String text, FontConfiguration fc, SURL source, double scale, Url url) throws IOException {
        if (source == null) {
            return AtomTextUtils.createLegacy("(Cannot decode: " + text + ")", fc);
        }
        BufferedImage read = source.readRasterImageFromURL();
        if (read == null) {
            return AtomTextUtils.createLegacy("(Cannot decode: " + text + ")", fc);
        }
        return new AtomImg(read, scale, url, "http");
    }

    private static Atom buildSvgFromUrl(String text, FontConfiguration fc, SURL source, double scale, Url url) throws IOException {
        if (source == null) {
            return AtomTextUtils.createLegacy("(Cannot decode SVG: " + text + ")", fc);
        }
        byte[] read = source.getBytes();
        if (read == null) {
            return AtomTextUtils.createLegacy("(Cannot decode SVG: " + text + ")", fc);
        }
        return new AtomImgSvg(new TileImageSvg(new String(read, StandardCharsets.UTF_8), scale));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D((double)this.image.getWidth() * this.scale, (double)this.image.getHeight() * this.scale);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug.draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)).withRawFileName(this.rawFileName).scale(this.scale));
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

