/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.utils.BlocLines;

public abstract class CommandMultilines<S extends Diagram>
implements Command<S> {
    private final Pattern2 starting;
    private final Pattern2 ending;

    public CommandMultilines(Pattern2 starting, Pattern2 ending) {
        this.starting = starting;
        this.ending = ending;
    }

    public final void getPatternEnd() {
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        Matcher2 m1 = this.starting.matcher(lines.getFirst().getTrimmed().getString());
        if (!m1.matches()) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        m1 = this.ending.matcher(lines.getLast().getTrimmed().getString());
        if (!m1.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        return this.finalVerification();
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected CommandControl finalVerification() {
        return CommandControl.OK;
    }

    protected final Pattern2 getStartingPattern() {
        return this.starting;
    }

    protected final Pattern2 getEndingPattern() {
        return this.ending;
    }

    @Override
    public boolean isEligibleFor(ParserPass pass) {
        return pass == ParserPass.ONE;
    }
}

