/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;

public class XADataSourceConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    static final String CLASS_NAME = XADataSourceConnectionFactoryAdapter.class.getName();
    protected XADataSource m_xaDataSource;

    public XADataSourceConnectionFactoryAdapter(XADataSource xaDataSource, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(diagnosticsCollector);
        if (null == xaDataSource) {
            UCPErrorHandler.throwUniversalConnectionPoolException(260);
        }
        this.m_xaDataSource = xaDataSource;
    }

    public XADataSourceConnectionFactoryAdapter(XADataSource xaDataSource) throws UniversalConnectionPoolException {
        this(xaDataSource, DiagnosticsCollectorImpl.getCommon());
    }

    public XADataSource getXaDataSource() {
        return this.m_xaDataSource;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRequestInfo;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter", "createConnection", "entering args ({0})", null, null, connectionRetrievalInfo);
            if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(252);
            }
            JDBCConnectionRetrievalInfo jdbcConnectionRequestInfo = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
            XAConnection xaConnection = null;
            try {
                xaConnection = this.m_xaDataSource.getXAConnection(jdbcConnectionRequestInfo.getUser(), jdbcConnectionRequestInfo.getPassword().get());
                UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
                if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
                    xaConnection.addConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
                }
                if (null != xaConnection) {
                    this.onSuccessfulConnectionCreation(xaConnection);
                }
            }
            catch (SQLException sqlException) {
                this.onFailedConnectionCreation(sqlException);
                this.trace(Level.WARNING, CLASS_NAME, "closeConnection", "", null, sqlException, new Object[0]);
                if (null != xaConnection) {
                    this.closeConnection(xaConnection);
                }
                UCPErrorHandler.throwUniversalConnectionPoolException(261, sqlException);
            }
            XAConnection xAConnection = xaConnection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter", "createConnection", "returning {0}", null, null, xAConnection);
            return xAConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter", "createConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void closeConnection(Object object) throws UniversalConnectionPoolException {
        try {
            void connection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter", "closeConnection", "entering args ({0})", null, null, object);
            if (!(connection instanceof XAConnection)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(262);
            }
            XAConnection xaConnection = (XAConnection)connection;
            UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
            if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
                xaConnection.removeConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
            }
            try {
                xaConnection.close();
            }
            catch (SQLException sqlException) {
                this.trace(Level.WARNING, CLASS_NAME, "closeConnection", "", null, sqlException, new Object[0]);
                UCPErrorHandler.throwUniversalConnectionPoolException(263);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter", "closeConnection", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter", "closeConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }
}

