/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.NUMBER;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonDecimalImpl
extends OracleJsonNumberImpl
implements OracleJsonDecimal {
    public static String NEGATIVE_INF = "\"-Inf\"";
    public static String POSITIVE_INF = "\"Inf\"";
    byte[] raw;
    OracleJsonDecimal.TargetType type;
    private static DecimalFormat SCIENTIFIC_FORMAT_POSITIVE_EXP;
    private static DecimalFormat SCIENTIFIC_FORMAT_NEGATIVE_EXP;

    public OracleJsonDecimalImpl(BigDecimal value) {
        this.raw = OsonPrimitiveConversions.toNumber(value);
    }

    public OracleJsonDecimalImpl(long value, OracleJsonDecimal.TargetType type) {
        this.raw = OsonPrimitiveConversions.toNumber(value);
        this.type = type;
    }

    public OracleJsonDecimalImpl(int value, OracleJsonDecimal.TargetType type) {
        this.raw = OsonPrimitiveConversions.toNumber((long)value);
        this.type = type;
    }

    public OracleJsonDecimalImpl(byte[] raw, OracleJsonDecimal.TargetType type) {
        this.raw = raw;
        this.type = type;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.DECIMAL;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OracleJsonDecimal)) {
            return false;
        }
        OracleJsonDecimal othern = (OracleJsonDecimal)other;
        return this.bigDecimalValue().equals(othern.bigDecimalValue());
    }

    @Override
    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }

    public void reset(byte[] raw, OracleJsonDecimal.TargetType type) {
        this.raw = raw;
        this.type = type;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return OsonPrimitiveConversions.toBigDecimal(this.raw);
    }

    public byte[] raw() {
        return this.raw;
    }

    @Override
    public String getString() {
        BigDecimal bd;
        int precision;
        int len = this.raw.length;
        if (len <= 2) {
            if (OsonPrimitiveConversions.isNegInf(this.raw, len, 0)) {
                return NEGATIVE_INF;
            }
            if (OsonPrimitiveConversions.isPosInf(this.raw)) {
                return POSITIVE_INF;
            }
        }
        if ((precision = (bd = OsonPrimitiveConversions.toBigDecimal(this.raw)).precision()) <= 40) {
            return bd.toPlainString();
        }
        return OracleJsonDecimalImpl.format(bd);
    }

    private static String format(BigDecimal x) {
        DecimalFormat format = x.scale() < 0 ? (DecimalFormat)SCIENTIFIC_FORMAT_NEGATIVE_EXP.clone() : (DecimalFormat)SCIENTIFIC_FORMAT_POSITIVE_EXP.clone();
        return format.format(x);
    }

    public boolean isDec() {
        return this.type == OracleJsonDecimal.TargetType.DECIMAL;
    }

    public boolean isSB4() {
        return this.type == OracleJsonDecimal.TargetType.INT;
    }

    public boolean isSB8() {
        return this.type == OracleJsonDecimal.TargetType.LONG;
    }

    @Override
    public NUMBER getNUMBER() {
        return new NUMBER(this.raw());
    }

    @Override
    public <T> T wrap(Class<T> c) {
        if (Jsonp.isJakartaJson(c)) {
            return c.cast(new JakartaPrimitive.JakartaNumberImpl(this.raw, this.type));
        }
        return c.cast(new JsonpPrimitive.JsonpNumberImpl(this.raw, this.type));
    }

    @Override
    public OracleJsonDecimal.TargetType getTargetType() {
        return this.type;
    }

    static {
        int p1 = 40;
        StringBuilder pattern = new StringBuilder(p1 + 5);
        pattern.append("0.");
        for (int i = 0; i < p1; ++i) {
            pattern.append('#');
        }
        pattern.append("E0");
        DecimalFormat fmt = new DecimalFormat(pattern.toString(), DecimalFormatSymbols.getInstance(Locale.US));
        fmt.setRoundingMode(RoundingMode.HALF_UP);
        SCIENTIFIC_FORMAT_POSITIVE_EXP = fmt;
        SCIENTIFIC_FORMAT_NEGATIVE_EXP = (DecimalFormat)fmt.clone();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setExponentSeparator("E+");
        SCIENTIFIC_FORMAT_POSITIVE_EXP.setDecimalFormatSymbols(symbols);
    }

    public static enum NumberType {
        NONE,
        SB4,
        SB8,
        DEC128;

    }
}

