/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.process;

import com.github.kokorin.jaffree.JaffreeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private final Thread starter;
    private final String contextName;
    private final List<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
    private final List<Thread> threads = new CopyOnWriteArrayList<Thread>();
    private final AtomicInteger runningCounter = new AtomicInteger();
    private final AtomicBoolean starterInterrupted = new AtomicBoolean();
    private volatile boolean stopped = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(Executor.class);

    public Executor(String contextName) {
        this.starter = Thread.currentThread();
        this.contextName = contextName;
    }

    public void execute(final String name, final Runnable runnable) {
        if (this.stopped) {
            throw new JaffreeException("Executor has been stopped already!");
        }
        if (this.starter != Thread.currentThread()) {
            throw new JaffreeException("Executors must be supplied in the same thread that created this Executor!");
        }
        final String threadName = this.getThreadName(name);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LOGGER.debug("{} thread has started", (Object)threadName);
                Executor.this.runningCounter.incrementAndGet();
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    LOGGER.debug("Exception in thread {}, collecting for later report. Message: {}", (Object)name, (Object)e.getMessage());
                    Executor.this.exceptions.add(e);
                    if (!Executor.this.stopped && Executor.this.starterInterrupted.compareAndSet(false, true)) {
                        LOGGER.warn("Interrupting starter thread ({}) because of exception: {}", (Object)Executor.this.starter.getName(), (Object)e.getMessage());
                        Executor.this.starter.interrupt();
                    }
                }
                finally {
                    Executor.this.runningCounter.decrementAndGet();
                    LOGGER.debug("{} thread has finished", (Object)name);
                }
            }
        }, threadName);
        thread.setDaemon(true);
        thread.start();
        this.threads.add(thread);
    }

    public List<Throwable> getExceptions() {
        return Collections.unmodifiableList(new ArrayList<Throwable>(this.exceptions));
    }

    public void stop() {
        this.stopped = true;
        LOGGER.debug("Stopping execution");
        for (Thread thread : this.threads) {
            if (!thread.isAlive() || thread.isInterrupted()) continue;
            LOGGER.warn("Interrupting ALIVE thread: {}", (Object)thread.getName());
            thread.interrupt();
        }
    }

    public boolean isRunning() {
        return this.runningCounter.get() > 0;
    }

    public List<String> getRunningThreadNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Thread thread : this.threads) {
            if (!thread.isAlive() || thread.isInterrupted()) continue;
            result.add(thread.getName());
        }
        return result;
    }

    private String getThreadName(String name) {
        if (this.contextName == null) {
            return name;
        }
        return this.contextName + "-" + name;
    }
}

