/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffprobe;

import com.github.kokorin.jaffree.ffprobe.Input;
import com.github.kokorin.jaffree.net.NegotiatingTcpServer;
import com.github.kokorin.jaffree.net.TcpNegotiator;
import com.github.kokorin.jaffree.net.TcpServer;
import com.github.kokorin.jaffree.process.ProcessHelper;

public abstract class TcpInput
implements Input {
    private final String url;
    private final TcpServer tcpServer;

    public TcpInput(TcpNegotiator negotiator) {
        this("tcp", negotiator);
    }

    public TcpInput(String protocol, TcpNegotiator negotiator) {
        this(protocol, "", negotiator);
    }

    public TcpInput(String protocol, String suffix, TcpNegotiator negotiator) {
        this(protocol, suffix, NegotiatingTcpServer.onRandomPort(negotiator));
    }

    protected TcpInput(String protocol, String suffix, TcpServer tcpServer) {
        this.url = protocol + "://" + tcpServer.getAddressAndPort() + suffix;
        this.tcpServer = tcpServer;
    }

    @Override
    public final String getUrl() {
        return this.url;
    }

    @Override
    public ProcessHelper helperThread() {
        return this.tcpServer;
    }
}

