/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.components;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.components.TimePicker;
import com.github.lgooddatepicker.components.TimePickerSettings;
import com.github.lgooddatepicker.optionalusertools.DateChangeListener;
import com.github.lgooddatepicker.optionalusertools.DateTimeChangeListener;
import com.github.lgooddatepicker.optionalusertools.TimeChangeListener;
import com.github.lgooddatepicker.zinternaltools.DateChangeEvent;
import com.github.lgooddatepicker.zinternaltools.DateTimeChangeEvent;
import com.github.lgooddatepicker.zinternaltools.TimeChangeEvent;
import com.privatejgoodies.forms.factories.CC;
import com.privatejgoodies.forms.layout.ColumnSpec;
import com.privatejgoodies.forms.layout.ConstantSize;
import com.privatejgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import javax.swing.JPanel;

public class DateTimePicker
extends JPanel {
    public DatePicker datePicker;
    private ArrayList<DateTimeChangeListener> dateTimeChangeListeners = new ArrayList();
    public TimePicker timePicker;

    public DateTimePicker() {
        this(null, null);
    }

    public DateTimePicker(DatePickerSettings datePickerSettingsOrNull, TimePickerSettings timePickerSettingsOrNull) {
        this.initComponents();
        DatePickerSettings dateSettings = datePickerSettingsOrNull == null ? new DatePickerSettings() : datePickerSettingsOrNull;
        TimePickerSettings timeSettings = timePickerSettingsOrNull == null ? new TimePickerSettings() : timePickerSettingsOrNull;
        this.datePicker = new DatePicker(dateSettings);
        this.timePicker = new TimePicker(timeSettings);
        this.add((Component)this.datePicker, CC.xy(1, 1));
        this.add((Component)this.timePicker, CC.xy(3, 1));
        DateTimeChangeListenerImplementation listener = new DateTimeChangeListenerImplementation(this);
        this.datePicker.addDateChangeListener(listener);
        this.timePicker.addTimeChangeListener(listener);
        int gapPixels = timeSettings.zDateTimePicker_GapBeforeTimePickerPixels == null ? 5 : timeSettings.zDateTimePicker_GapBeforeTimePickerPixels;
        this.setGapSize(gapPixels, ConstantSize.PIXEL);
        if (dateSettings.getGapBeforeButtonPixels() == null) {
            this.datePicker.getSettings().setGapBeforeButtonPixels(0);
        }
        if (timeSettings.getGapBeforeButtonPixels() == null) {
            this.timePicker.getSettings().setGapBeforeButtonPixels(0);
        }
    }

    public void addDateTimeChangeListener(DateTimeChangeListener listener) {
        this.dateTimeChangeListeners.add(listener);
    }

    public void clear() {
        this.datePicker.clear();
        this.timePicker.clear();
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.datePicker.getBaseline(width, height);
    }

    public DatePicker getDatePicker() {
        return this.datePicker;
    }

    public void removeDateTimeChangeListener(DateTimeChangeListener listener) {
        this.dateTimeChangeListeners.remove(listener);
    }

    public ArrayList<DateTimeChangeListener> getDateTimeChangeListeners() {
        return new ArrayList<DateTimeChangeListener>(this.dateTimeChangeListeners);
    }

    public LocalDateTime getDateTimePermissive() {
        LocalDate dateValue = this.datePicker.getDate();
        LocalTime timeValue = this.timePicker.getTime();
        LocalTime localTime = timeValue = timeValue == null ? LocalTime.MIDNIGHT : timeValue;
        if (dateValue == null) {
            return null;
        }
        return LocalDateTime.of(dateValue, timeValue);
    }

    public LocalDateTime getDateTimeStrict() {
        LocalDate dateValue = this.datePicker.getDate();
        LocalTime timeValue = this.timePicker.getTime();
        if (dateValue == null || timeValue == null) {
            return null;
        }
        return LocalDateTime.of(dateValue, timeValue);
    }

    public TimePicker getTimePicker() {
        return this.timePicker;
    }

    public boolean isDateTimeAllowed(LocalDateTime value) {
        LocalDate datePortion = value == null ? null : value.toLocalDate();
        LocalTime timePortion = value == null ? null : value.toLocalTime();
        boolean isDateAllowed = this.datePicker.isDateAllowed(datePortion);
        boolean isTimeAllowed = this.timePicker.isTimeAllowed(timePortion);
        return isDateAllowed && isTimeAllowed;
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void setDateTimePermissive(LocalDateTime optionalDateTime) {
        if (optionalDateTime == null) {
            this.datePicker.setDate(null);
            this.timePicker.setTime(null);
            return;
        }
        this.datePicker.setDate(optionalDateTime.toLocalDate());
        this.timePicker.setTime(optionalDateTime.toLocalTime());
    }

    public void setDateTimeStrict(LocalDateTime optionalDateTime) {
        this.setDateTimePermissive(optionalDateTime);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.datePicker.setEnabled(enabled);
        this.timePicker.setEnabled(enabled);
    }

    public void setGapSize(int gapSize, ConstantSize.Unit units) {
        ConstantSize gapSizeObject = new ConstantSize(gapSize, units);
        ColumnSpec columnSpec = ColumnSpec.createGap(gapSizeObject);
        FormLayout layout = (FormLayout)this.getLayout();
        layout.setColumnSpec(2, columnSpec);
    }

    @Override
    public String toString() {
        return this.toStringPermissive();
    }

    public String toStringPermissive() {
        LocalDateTime dateTime = this.getDateTimePermissive();
        String text = dateTime == null ? "" : dateTime.toString();
        return text;
    }

    public String toStringStrict() {
        LocalDateTime dateTime = this.getDateTimeStrict();
        String text = dateTime == null ? "" : dateTime.toString();
        return text;
    }

    private void initComponents() {
        this.setLayout(new FormLayout("pref:grow, 5px, pref:grow(0.6)", "fill:pref:grow"));
    }

    private class DateTimeChangeListenerImplementation
    implements DateChangeListener,
    TimeChangeListener {
        private final DateTimePicker source;

        public DateTimeChangeListenerImplementation(DateTimePicker source) {
            this.source = source;
        }

        @Override
        public void dateChanged(DateChangeEvent dateChangeEvent) {
            this.reportDateOrTimeChange(dateChangeEvent, null);
        }

        @Override
        public void timeChanged(TimeChangeEvent timeChangeEvent) {
            this.reportDateOrTimeChange(null, timeChangeEvent);
        }

        private void reportDateOrTimeChange(DateChangeEvent dateEvent, TimeChangeEvent timeEvent) {
            DateTimeChangeEvent summaryEvent = new DateTimeChangeEvent(this.source, this.source.datePicker, this.source.timePicker, dateEvent, timeEvent);
            for (DateTimeChangeListener listener : DateTimePicker.this.dateTimeChangeListeners) {
                listener.dateOrTimeChanged(summaryEvent);
            }
            DateTimePicker.this.firePropertyChange("dateTimePermissive", summaryEvent.getOldDateTimePermissive(), summaryEvent.getNewDateTimePermissive());
            DateTimePicker.this.firePropertyChange("dateTimeStrict", summaryEvent.getOldDateTimeStrict(), summaryEvent.getNewDateTimeStrict());
        }
    }
}

