/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_downloads;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.gui.messages.DownloadRateLimitChangedEvent;
import mediathek.gui.messages.ParallelDownloadNumberChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0003J\b\u0010\f\u001a\u00020\u0005H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmediathek/gui/tabs/tab_downloads/DownloadsConfigPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "setupDownloadRateLimitCheckBox", "", "fireDownloadRateLimitChangedEvent", "setupDownloadRateLimitSpinner", "setupNumDownloadsSpinner", "handleParallelDownloadNumberChange", "e", "Lmediathek/gui/messages/ParallelDownloadNumberChangedEvent;", "initComponents", "spinnerNumDownloads", "Ljavax/swing/JSpinner;", "cbMaxBandwidth", "Ljavax/swing/JCheckBox;", "spinnerMaxBandwidth", "MediathekView"})
public final class DownloadsConfigPanel
extends JPanel {
    @NotNull
    private final JSpinner spinnerNumDownloads = new JSpinner();
    @NotNull
    private final JCheckBox cbMaxBandwidth = new JCheckBox();
    @NotNull
    private final JSpinner spinnerMaxBandwidth = new JSpinner();

    public DownloadsConfigPanel() {
        this.initComponents();
        this.cbMaxBandwidth.setToolTipText("Bandbreitenbegrenzung aktiviert?");
        this.setupNumDownloadsSpinner();
        this.setupDownloadRateLimitCheckBox();
        this.setupDownloadRateLimitSpinner();
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    private final void setupDownloadRateLimitCheckBox() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        boolean active = config.getBoolean("download.rate.active", false);
        this.cbMaxBandwidth.setSelected(active);
        this.cbMaxBandwidth.addActionListener(arg_0 -> DownloadsConfigPanel.setupDownloadRateLimitCheckBox$lambda$0(config, this, arg_0));
    }

    private final void fireDownloadRateLimitChangedEvent() {
        Object object = this.spinnerMaxBandwidth.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int downloadLimit = (Integer)object;
        ApplicationConfiguration.getConfiguration().setProperty("download.rate.limit", (Object)downloadLimit);
        DownloadRateLimitChangedEvent evt = new DownloadRateLimitChangedEvent();
        evt.newLimit = downloadLimit;
        evt.active = this.cbMaxBandwidth.isSelected();
        MessageBus.getMessageBus().publishAsync((Object)evt);
    }

    private final void setupDownloadRateLimitSpinner() {
        this.spinnerMaxBandwidth.putClientProperty("JComponent.roundRect", true);
        this.spinnerMaxBandwidth.setModel(new SpinnerNumberModel(0, 0, 0x100000, 1));
        this.spinnerMaxBandwidth.setToolTipText("<html>Bandbreitenbegrenzung eines Downloads in XX Kilobytes pro Sekunde.\n<b><br><u>WICHTIG:</u><br>ENTWEDER<br>den Wert \u00fcber die Pfeiltasten \u00e4ndern<br>ODER<br>Zahlen eingeben UND ENTER-Taste dr\u00fccken!</b>\n</html>");
        long oldDownloadLimit = ApplicationConfiguration.getConfiguration().getLong("download.rate.limit", 0L);
        this.spinnerMaxBandwidth.setValue(oldDownloadLimit);
        this.spinnerMaxBandwidth.addChangeListener(arg_0 -> DownloadsConfigPanel.setupDownloadRateLimitSpinner$lambda$0(this, arg_0));
    }

    private final void setupNumDownloadsSpinner() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.spinnerNumDownloads.putClientProperty("JComponent.roundRect", true);
        this.spinnerNumDownloads.setModel(new SpinnerNumberModel(1, 1, 9, 1));
        this.spinnerNumDownloads.setValue(config.getInt("download.max_simultaneous.number", 1));
        this.spinnerNumDownloads.addChangeListener(arg_0 -> DownloadsConfigPanel.setupNumDownloadsSpinner$lambda$0(this, config, arg_0));
    }

    @Handler
    private final void handleParallelDownloadNumberChange(ParallelDownloadNumberChangedEvent e) {
        SwingUtilities.invokeLater(() -> DownloadsConfigPanel.handleParallelDownloadNumberChange$lambda$0(this));
    }

    private final void initComponents() {
        this.setBorder(new TitledBorder("Downloads"));
        this.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3).align("center", "center"), new AC().align("center").gap().align("label").gap().align("left").gap().align("center"), new AC().gap()));
        int[] nArray = new int[]{1, 0};
        this.add((Component)new JLabel("gleichzeitig:"), new CC().cell(nArray));
        nArray = new int[]{2, 0};
        this.add((Component)this.spinnerNumDownloads, new CC().cell(nArray).width("80:100"));
        nArray = new int[]{0, 1};
        this.add((Component)this.cbMaxBandwidth, new CC().cell(nArray));
        nArray = new int[]{1, 1};
        this.add((Component)new JLabel("max. Bandbreite:"), new CC().cell(nArray));
        nArray = new int[]{2, 1};
        this.add((Component)this.spinnerMaxBandwidth, new CC().cell(nArray).width("80:100"));
        nArray = new int[]{3, 1};
        this.add((Component)new JLabel("KiB/s"), new CC().cell(nArray));
    }

    private static final void setupDownloadRateLimitCheckBox$lambda$0(Configuration $config, DownloadsConfigPanel this$0, ActionEvent it) {
        $config.setProperty("download.rate.active", (Object)this$0.cbMaxBandwidth.isSelected());
        this$0.fireDownloadRateLimitChangedEvent();
    }

    private static final void setupDownloadRateLimitSpinner$lambda$0(DownloadsConfigPanel this$0, ChangeEvent it) {
        this$0.fireDownloadRateLimitChangedEvent();
    }

    private static final void setupNumDownloadsSpinner$lambda$0(DownloadsConfigPanel this$0, Configuration $config, ChangeEvent it) {
        Object object = this$0.spinnerNumDownloads.getModel().getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        int maxNumDownloads = ((Number)object).intValue();
        $config.setProperty("download.max_simultaneous.number", (Object)maxNumDownloads);
        MessageBus.getMessageBus().publishAsync((Object)new ParallelDownloadNumberChangedEvent());
    }

    private static final void handleParallelDownloadNumberChange$lambda$0(DownloadsConfigPanel this$0) {
        int maxNumDownloads = ApplicationConfiguration.getConfiguration().getInt("download.max_simultaneous.number", 1);
        this$0.spinnerNumDownloads.setValue(maxNumDownloads);
    }
}

