/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import mediathek.config.Daten;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.dialogEinstellungen.BlacklistRuleTableModel;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Filter;
import mediathek.tool.GetFile;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Listener;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.SenderListComboBoxModel;
import mediathek.tool.TextCopyPasteHandler;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.VerticalLayout;

public class PanelBlacklist
extends JPanel {
    public boolean ok;
    private final String name;
    private final Daten daten;
    private final JFrame parentComponent;
    private static final Logger logger = LogManager.getLogger();
    private final BlacklistRuleTableModel tableModel = new BlacklistRuleTableModel();
    private JTable jTableBlacklist;
    private JComboBox<String> jComboBoxSender;
    private JComboBox<String> jComboBoxThema;
    private JButton jButtonHinzufuegen;
    private JTextField jTextFieldTitel;
    private JTextField jTextFieldThemaTitel;
    private JButton jButtonAendern;
    private JRadioButton jRadioButtonBlacklist;
    private JRadioButton jRadioButtonWhitelist;
    private JButton jButtonHilfe;
    private JTextField tfFilter;
    private JButton btnFilterTable;
    private JLabel lblNumEntries;
    private JButton jButtonTabelleLoeschen;
    private JCheckBox jCheckBoxZukunftNichtAnzeigen;
    private JCheckBox jCheckBoxGeo;
    private JSlider jSliderMinuten;
    private JTextField jTextFieldMinuten;
    private JCheckBox jCheckBoxStart;
    private JCheckBox jCheckBoxBlacklistEingeschaltet;
    private JCheckBox jCheckBoxAbo;

    public PanelBlacklist(Daten d, JFrame parentComponent, String nname) {
        this.daten = d;
        this.parentComponent = parentComponent;
        this.initComponents();
        this.name = nname;
        this.jButtonHilfe.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
        this.jButtonTabelleLoeschen.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/trash-can.svg"));
        this.jButtonAendern.setEnabled(this.jTableBlacklist.getSelectionModel().getSelectedItemsCount() == 1);
        this.jTableBlacklist.setModel(this.tableModel);
        this.tableModel.addTableModelListener(tableModelEvent -> this.jButtonTabelleLoeschen.setEnabled(this.tableModel.getRowCount() != 0));
        this.jTableBlacklist.getSelectionModel().addListSelectionListener(l -> {
            if (!l.getValueIsAdjusting()) {
                this.jButtonAendern.setEnabled(this.jTableBlacklist.getSelectionModel().getSelectedItemsCount() == 1);
                if (this.jTableBlacklist.getSelectionModel().getSelectedItemsCount() == 0) {
                    this.resetRuleEntryFields();
                }
            }
        });
        this.jCheckBoxGeo.addActionListener(e -> {
            ApplicationConfiguration.getInstance().setBlacklistDoNotShowGeoblockedFilms(this.jCheckBoxGeo.isSelected());
            this.notifyBlacklistChanged();
        });
        this.init_();
        this.init();
        MessageBus.getMessageBus().subscribe((Object)this);
        Listener.addListener(new Listener(this, 40, this.name){
            final /* synthetic */ PanelBlacklist this$0;
            {
                PanelBlacklist panelBlacklist = this$0;
                Objects.requireNonNull(panelBlacklist);
                this.this$0 = panelBlacklist;
                super(eereignis, kklasse);
            }

            @Override
            public void ping() {
                this.this$0.jCheckBoxStart.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_START_ON)));
            }
        });
        Listener.addListener(new Listener(this, 27, this.name){
            final /* synthetic */ PanelBlacklist this$0;
            {
                PanelBlacklist panelBlacklist = this$0;
                Objects.requireNonNull(panelBlacklist);
                this.this$0 = panelBlacklist;
                super(eereignis, kklasse);
            }

            @Override
            public void ping() {
                this.this$0.init_();
            }
        });
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(this){
            final /* synthetic */ PanelBlacklist this$0;
            {
                PanelBlacklist panelBlacklist = this$0;
                Objects.requireNonNull(panelBlacklist);
                this.this$0 = panelBlacklist;
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                this.this$0.comboThemaLaden();
            }
        });
        this.setupTableFilter();
        this.lblNumEntries.setText(Integer.toString(this.jTableBlacklist.getRowCount()));
        this.jTableBlacklist.getModel().addTableModelListener(tableModelEvent -> this.lblNumEntries.setText(Integer.toString(this.jTableBlacklist.getRowCount())));
    }

    private void setupTableFilter() {
        TableRowSorter<BlacklistRuleTableModel> sorter = new TableRowSorter<BlacklistRuleTableModel>(this.tableModel);
        sorter.setStringConverter(new TableStringConverter(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public String toString(TableModel model, int row, int column) {
                return model.getValueAt(row, column).toString().toLowerCase();
            }
        });
        this.jTableBlacklist.setRowSorter(sorter);
        this.btnFilterTable.addActionListener(actionEvent -> {
            String text = this.tfFilter.getText();
            if (text.isEmpty()) {
                sorter.setRowFilter(null);
            } else {
                try {
                    sorter.setRowFilter(RowFilter.regexFilter(text.toLowerCase(), new int[0]));
                }
                catch (PatternSyntaxException pse) {
                    logger.error("Bad regex pattern", (Throwable)pse);
                }
            }
        });
    }

    private void resetRuleEntryFields() {
        this.jTextFieldTitel.setText("");
        this.jTextFieldThemaTitel.setText("");
        this.jComboBoxThema.setSelectedItem("");
        this.jComboBoxSender.setSelectedItem("");
    }

    @Handler
    private void handleBlacklistChangedEvent(BlacklistChangedEvent e) {
        SwingUtilities.invokeLater(this::init_);
    }

    private void init_() {
        this.jCheckBoxAbo.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_AUCH_ABO)));
        this.jCheckBoxStart.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_START_ON)));
        boolean blacklist_is_on = ApplicationConfiguration.getConfiguration().getBoolean("blacklist.is_on", false);
        this.jCheckBoxBlacklistEingeschaltet.setSelected(blacklist_is_on);
        this.jCheckBoxZukunftNichtAnzeigen.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ZUKUNFT_NICHT_ANZEIGEN)));
        this.jCheckBoxGeo.setSelected(ApplicationConfiguration.getInstance().getBlacklistDoNotShowGeoblockedFilms());
        try {
            this.jSliderMinuten.setValue(Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE)));
        }
        catch (Exception ex) {
            this.jSliderMinuten.setValue(0);
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE, "0");
        }
        this.tableModel.fireTableDataChanged();
    }

    private void init() {
        this.jTableBlacklist.addMouseListener(new BeobMausTabelle(this));
        this.jTableBlacklist.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.fillControlsWithRuleData();
            }
        });
        this.jRadioButtonWhitelist.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST)));
        this.jRadioButtonWhitelist.addActionListener(actionEvent -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST, Boolean.toString(this.jRadioButtonWhitelist.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jRadioButtonBlacklist.addActionListener(actionEvent -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST, Boolean.toString(this.jRadioButtonWhitelist.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jCheckBoxZukunftNichtAnzeigen.addActionListener(actionEvent -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_ZUKUNFT_NICHT_ANZEIGEN, Boolean.toString(this.jCheckBoxZukunftNichtAnzeigen.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jCheckBoxAbo.addActionListener(actionEvent -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_AUCH_ABO, Boolean.toString(this.jCheckBoxAbo.isSelected()));
            Listener.notify(27, this.name);
        });
        this.jCheckBoxStart.addActionListener(actionEvent -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_START_ON, Boolean.toString(this.jCheckBoxStart.isSelected()));
            Listener.notify(40, this.name);
        });
        this.jCheckBoxBlacklistEingeschaltet.addActionListener(actionEvent -> {
            ApplicationConfiguration.getConfiguration().setProperty("blacklist.is_on", (Object)this.jCheckBoxBlacklistEingeschaltet.isSelected());
            this.notifyBlacklistChanged();
        });
        this.jButtonHinzufuegen.addActionListener(actionEvent -> this.onAddBlacklistRule());
        this.jButtonAendern.addActionListener(actionEvent -> this.onChangeBlacklistRule());
        this.jButtonHilfe.addActionListener(actionEvent -> {
            new GetFile();
            new DialogHilfe(this.parentComponent, true, GetFile.getHilfeSuchen("/mediathek/file/hilfetext_blacklist.txt")).setVisible(true);
        });
        this.jButtonTabelleLoeschen.addActionListener(actionEvent -> {
            int ret = JOptionPane.showConfirmDialog(this.parentComponent, "<html>M\u00f6chten Sie wirklich <b>alle Regeln</b> dauerhaft l\u00f6schen?</html>", "Blacklist Regeln", 0);
            if (ret == 0) {
                this.tableModel.removeAll();
            }
        });
        this.jComboBoxSender.addActionListener(actionEvent -> this.comboThemaLaden());
        DocumentListener documentListener = new DocumentListener(this){
            final /* synthetic */ PanelBlacklist this$0;
            {
                PanelBlacklist panelBlacklist = this$0;
                Objects.requireNonNull(panelBlacklist);
                this.this$0 = panelBlacklist;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                this.validatePatternInput(this.this$0.jTextFieldThemaTitel);
                this.validatePatternInput(this.this$0.jTextFieldTitel);
            }

            private void validatePatternInput(JTextField tf) {
                String text = tf.getText();
                if (Filter.isPattern(text)) {
                    tf.setForeground(MVColor.getRegExPatternColor());
                    GuiFunktionen.showErrorIndication(tf, Filter.makePatternNoCache(text) == null);
                } else {
                    GuiFunktionen.showErrorIndication(tf, false);
                    tf.setForeground(UIManager.getColor("TextField.foreground"));
                }
            }
        };
        this.jTextFieldTitel.getDocument().addDocumentListener(documentListener);
        this.jTextFieldThemaTitel.getDocument().addDocumentListener(documentListener);
        try {
            this.jSliderMinuten.setValue(Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE)));
        }
        catch (Exception ex) {
            this.jSliderMinuten.setValue(0);
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE, "0");
        }
        this.jTextFieldMinuten.setText(String.valueOf(this.jSliderMinuten.getValue()));
        if (this.jSliderMinuten.getValue() == 0) {
            this.jTextFieldMinuten.setText("alles");
        }
        this.jSliderMinuten.addChangeListener(changeEvent -> {
            this.jTextFieldMinuten.setText(String.valueOf(this.jSliderMinuten.getValue()));
            if (this.jSliderMinuten.getValue() == 0) {
                this.jTextFieldMinuten.setText("alles");
            }
            if (!this.jSliderMinuten.getValueIsAdjusting()) {
                MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE, String.valueOf(this.jSliderMinuten.getValue()));
                this.notifyBlacklistChanged();
            }
        });
        this.jComboBoxSender.setModel((ComboBoxModel<String>)((Object)new SenderListComboBoxModel()));
        this.comboThemaLaden();
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldThemaTitel);
        this.jTextFieldThemaTitel.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldTitel);
        this.jTextFieldTitel.setComponentPopupMenu(handler.getPopupMenu());
    }

    private void onChangeBlacklistRule() {
        int selectedTableRow;
        String strSender = Objects.requireNonNull(this.jComboBoxSender.getSelectedItem()).toString();
        String strThema = Objects.requireNonNull(this.jComboBoxThema.getSelectedItem()).toString();
        String strTitel = this.jTextFieldTitel.getText().trim();
        String strThemaTitel = this.jTextFieldThemaTitel.getText().trim();
        if (!(strSender.isEmpty() && strThema.isEmpty() && strTitel.isEmpty() && strThemaTitel.isEmpty() || (selectedTableRow = this.jTableBlacklist.getSelectedRow()) == -1)) {
            int modelIndex = this.jTableBlacklist.convertRowIndexToModel(selectedTableRow);
            BlacklistRule bl = this.tableModel.get(modelIndex);
            bl.setSender(strSender);
            bl.setThema(strThema);
            bl.setTitel(strTitel);
            bl.setThema_titel(strThemaTitel);
            this.tableModel.fireTableRowsUpdated(modelIndex, modelIndex);
            this.notifyBlacklistChanged();
        }
    }

    private void notifyBlacklistChanged() {
        this.daten.getListeBlacklist().filterListe();
        MessageBus.getMessageBus().publishAsync((Object)new BlacklistChangedEvent());
    }

    private void comboThemaLaden() {
        String filterSender = Objects.requireNonNull(this.jComboBoxSender.getSelectedItem()).toString();
        if (filterSender.isEmpty()) {
            filterSender = "";
        }
        List<String> lst = this.daten.getListeFilme().getThemen(filterSender);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        for (String item : lst) {
            model.addElement(item);
        }
        this.jComboBoxThema.setModel(model);
    }

    private void fillControlsWithRuleData() {
        int selectedTableRow = this.jTableBlacklist.getSelectedRow();
        if (selectedTableRow != -1) {
            int modelIndex = this.jTableBlacklist.convertRowIndexToModel(selectedTableRow);
            BlacklistRule bl = this.tableModel.get(modelIndex);
            this.jComboBoxSender.setSelectedItem(bl.getSender());
            this.jComboBoxThema.setSelectedItem(bl.getThema());
            this.jTextFieldTitel.setText(bl.getTitel());
            this.jTextFieldThemaTitel.setText(bl.getThema_titel());
        }
    }

    private void onAddBlacklistRule() {
        String strSender = Objects.requireNonNull(this.jComboBoxSender.getSelectedItem()).toString();
        String strThema = Objects.requireNonNull(this.jComboBoxThema.getSelectedItem()).toString();
        String strTitel = this.jTextFieldTitel.getText().trim();
        String strThemaTitel = this.jTextFieldThemaTitel.getText().trim();
        if (!(strSender.isEmpty() && strThema.isEmpty() && strTitel.isEmpty() && strThemaTitel.isEmpty())) {
            BlacklistRule rule = new BlacklistRule(strSender, strThema, strTitel, strThemaTitel);
            if (!this.tableModel.contains(rule)) {
                this.tableModel.addRule(rule);
                this.resetRuleEntryFields();
            } else {
                String msg = "Es existiert bereits eine gleichlautende Regel.\nEs d\u00fcrfen keine Duplikate in der Liste vorkommen.\n";
                MVMessageDialog.showMessageDialog(this, msg, "MediathekView", 0);
            }
        }
    }

    private void initComponents() {
        JTabbedPane jTabbedPaneBlacklist = new JTabbedPane();
        JPanel jPanel1 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTableBlacklist = new JTable();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel5 = new JLabel();
        this.jComboBoxSender = new JComboBox();
        JLabel jLabel6 = new JLabel();
        this.jComboBoxThema = new JComboBox();
        this.jButtonHinzufuegen = new JButton();
        JLabel jLabel8 = new JLabel();
        this.jTextFieldTitel = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldThemaTitel = new JTextField();
        this.jButtonAendern = new JButton();
        JPanel panel2 = new JPanel();
        this.jRadioButtonBlacklist = new JRadioButton();
        this.jRadioButtonWhitelist = new JRadioButton();
        this.jButtonHilfe = new JButton();
        JSeparator separator1 = new JSeparator();
        JLabel label1 = new JLabel();
        this.tfFilter = new JTextField();
        this.btnFilterTable = new JButton();
        JPanel panel1 = new JPanel();
        JPanel panel3 = new JPanel();
        JLabel label2 = new JLabel();
        this.lblNumEntries = new JLabel();
        JLabel jLabel10 = new JLabel();
        this.jButtonTabelleLoeschen = new JButton();
        JSeparator separator2 = new JSeparator();
        JPanel jPanel3 = new JPanel();
        this.jCheckBoxZukunftNichtAnzeigen = new JCheckBox();
        this.jCheckBoxGeo = new JCheckBox();
        JPanel jPanel6 = new JPanel();
        this.jSliderMinuten = new JSlider();
        JLabel jLabel1 = new JLabel();
        this.jTextFieldMinuten = new JTextField();
        JLabel jLabel13 = new JLabel();
        JPanel jPanel8 = new JPanel();
        this.jCheckBoxStart = new JCheckBox();
        this.jCheckBoxBlacklistEingeschaltet = new JCheckBox();
        this.jCheckBoxAbo = new JCheckBox();
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 800));
        this.setLayout(new BorderLayout());
        jPanel1.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().grow().fill(), new AC().gap().gap().gap().gap().grow().fill().gap().gap().gap()));
        jScrollPane1.setMinimumSize(new Dimension(22, 50));
        jScrollPane1.setPreferredSize(new Dimension(454, 200));
        jScrollPane1.setViewportView(this.jTableBlacklist);
        jPanel1.add((Component)jScrollPane1, new CC().cell(new int[]{0, 4}));
        jPanel4.setBorder(new TitledBorder("Sender, Thema, Titel oder Thema/Titel:"));
        jLabel5.setText("Sender:");
        this.jComboBoxSender.setModel(new DefaultComboBoxModel<String>(new String[0]));
        jLabel6.setText("Thema:");
        this.jComboBoxThema.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.jButtonHinzufuegen.setText("Hinzuf\u00fcgen");
        jLabel8.setText("Titel:");
        jLabel2.setText("Thema oder Titel:");
        this.jButtonAendern.setText("\u00c4ndern");
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addGap(68, 68, 68).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel6).addComponent(jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup().addComponent(this.jComboBoxSender, -1, 714, Short.MAX_VALUE).addComponent(this.jComboBoxThema))).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel2).addComponent(jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup().addComponent(this.jTextFieldTitel).addComponent(this.jTextFieldThemaTitel))).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(0, 620, Short.MAX_VALUE).addComponent(this.jButtonAendern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHinzufuegen))).addContainerGap()));
        jPanel4Layout.linkSize(0, this.jButtonAendern, this.jButtonHinzufuegen);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.jComboBoxSender, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(this.jComboBoxThema, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel8).addComponent(this.jTextFieldTitel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.jTextFieldThemaTitel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHinzufuegen).addComponent(this.jButtonAendern)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(1, this.jComboBoxSender, this.jComboBoxThema, this.jTextFieldThemaTitel, this.jTextFieldTitel);
        jPanel1.add((Component)jPanel4, new CC().cell(new int[]{0, 7}));
        panel2.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().align("right"), new AC().fill().gap().fill()));
        this.jRadioButtonBlacklist.setSelected(true);
        this.jRadioButtonBlacklist.setText("\"Sender / Thema / Titel\" werden nicht angezeigt (Blacklist)");
        panel2.add((Component)this.jRadioButtonBlacklist, new CC().cell(new int[]{0, 0}));
        this.jRadioButtonWhitelist.setText("nur diese \"Sender / Thema / Titel\" anzeigen (Whitelist)");
        panel2.add((Component)this.jRadioButtonWhitelist, new CC().cell(new int[]{0, 1}));
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        panel2.add((Component)this.jButtonHilfe, new CC().cell(new int[]{1, 0, 1, 2}).alignX("right").alignY("center").grow(new float[]{0.0f, 0.0f}));
        jPanel1.add((Component)panel2, new CC().cell(new int[]{0, 0}));
        jPanel1.add((Component)separator1, new CC().cell(new int[]{0, 2}));
        label1.setText("Suchstring:");
        jPanel1.add((Component)label1, new CC().cell(new int[]{0, 3}).alignX("center").growX(0.0f));
        this.tfFilter.setToolTipText("<html>Hier wird der Suchtext als RegExp eingegeben.<br>Zum Zur\u00fccksetzen des Filters den Suchtext <b>l\u00f6schen</b> und erneut <i>\"Filtern\"</i> dr\u00fccken.</html>");
        jPanel1.add((Component)this.tfFilter, new CC().cell(new int[]{0, 3}));
        this.btnFilterTable.setText("Filtern");
        jPanel1.add((Component)this.btnFilterTable, new CC().cell(new int[]{0, 3}).alignX("center").growX(0.0f));
        panel1.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "0"), new AC().fill().gap().grow().fill().gap().fill(), new AC().grow().align("center")));
        panel3.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "0"), new AC().fill().gap().fill(), new AC().grow().align("center")));
        label2.setText("Eintr\u00e4ge:");
        panel3.add((Component)label2, new CC().cell(new int[]{0, 0}));
        this.lblNumEntries.setText("0");
        panel3.add((Component)this.lblNumEntries, new CC().cell(new int[]{1, 0}));
        panel1.add((Component)panel3, new CC().cell(new int[]{0, 0}));
        jLabel10.setText("Alle Eintr\u00e4ge l\u00f6schen:");
        jLabel10.setHorizontalAlignment(4);
        panel1.add((Component)jLabel10, new CC().cell(new int[]{1, 0}));
        this.jButtonTabelleLoeschen.setToolTipText("Alle Eintr\u00e4ge l\u00f6schen");
        panel1.add((Component)this.jButtonTabelleLoeschen, new CC().cell(new int[]{2, 0}));
        jPanel1.add((Component)panel1, new CC().cell(new int[]{0, 5}));
        jPanel1.add((Component)separator2, new CC().cell(new int[]{0, 6}));
        jTabbedPaneBlacklist.addTab("Sender-Thema-Titel", jPanel1);
        jPanel3.setLayout((LayoutManager)new VerticalLayout(5));
        this.jCheckBoxZukunftNichtAnzeigen.setText("Filme mit Datum in der Zukunft nicht anzeigen");
        jPanel3.add(this.jCheckBoxZukunftNichtAnzeigen);
        this.jCheckBoxGeo.setText("Filme, die per Geoblocking gesperrt sind, nicht anzeigen");
        this.jCheckBoxGeo.setToolTipText("<html>Geogeblockte Filme k\u00f6nnen im jeweiligen \"Ausland\" nicht abgerufen werden.<br>Dazu muss die eigene Position in den Einstellungen angegeben werden</html>");
        jPanel3.add(this.jCheckBoxGeo);
        jPanel6.setBorder(new EtchedBorder());
        this.jSliderMinuten.setValue(0);
        jLabel1.setText("Nur Filme anzeigen mit einer L\u00e4nge von mehr als [min]:");
        this.jTextFieldMinuten.setEditable(false);
        jLabel13.setText("Filme, die keine L\u00e4ngenangabe haben, werden immer angezeigt.");
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup().addComponent(this.jSliderMinuten, -1, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldMinuten, -2, 81, -2)).addComponent(jLabel13)).addGap(0, 424, Short.MAX_VALUE))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jTextFieldMinuten, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSliderMinuten, -2, -1, -2).addContainerGap()));
        jPanel3.add(jPanel6);
        jTabbedPaneBlacklist.addTab("Blacklist allgemein", jPanel3);
        this.add((Component)jTabbedPaneBlacklist, "Center");
        jPanel8.setBorder(new TitledBorder("Allgemeine Einstellungen"));
        jPanel8.setLayout(new GridLayout(3, 1));
        this.jCheckBoxStart.setText("Beim Programmstart einschalten");
        jPanel8.add(this.jCheckBoxStart);
        this.jCheckBoxBlacklistEingeschaltet.setText("Im Tab Filme einschalten");
        jPanel8.add(this.jCheckBoxBlacklistEingeschaltet);
        this.jCheckBoxAbo.setText("Bei der Suche nach Abos ber\u00fccksichtigen");
        this.jCheckBoxAbo.setToolTipText("<html>Die Blacklist beim Suchen nach Abos ber\u00fccksichtigen.<br/>Ansonsten wird die komplette Filmliste durchsucht.</html>");
        jPanel8.add(this.jCheckBoxAbo);
        this.add((Component)jPanel8, "North");
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonBlacklist);
        buttonGroup1.add(this.jRadioButtonWhitelist);
    }

    private class BeobMausTabelle
    extends MouseAdapter {
        final /* synthetic */ PanelBlacklist this$0;

        private BeobMausTabelle(PanelBlacklist panelBlacklist) {
            PanelBlacklist panelBlacklist2 = panelBlacklist;
            Objects.requireNonNull(panelBlacklist2);
            this.this$0 = panelBlacklist2;
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void onRemoveBlacklistRules() {
            int[] selectedIndices = this.this$0.jTableBlacklist.getSelectionModel().getSelectedIndices();
            if (selectedIndices.length == 1) {
                int modelIndex = this.this$0.jTableBlacklist.convertRowIndexToModel(selectedIndices[0]);
                this.this$0.tableModel.removeRow(modelIndex);
            } else {
                ArrayList<BlacklistRule> tempStore = new ArrayList<BlacklistRule>();
                for (int selectedRow : selectedIndices) {
                    int modelIndex = this.this$0.jTableBlacklist.convertRowIndexToModel(selectedRow);
                    BlacklistRule rule = this.this$0.tableModel.get(modelIndex);
                    tempStore.add(rule);
                }
                this.this$0.tableModel.removeRules(tempStore);
            }
        }

        private void showMenu(MouseEvent evt) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            String menuText = this.this$0.jTableBlacklist.getSelectedRowCount() > 1 ? "Zeilen l\u00f6schen" : "Zeile l\u00f6schen";
            JMenuItem item = new JMenuItem(menuText);
            item.addActionListener(actionEvent -> this.onRemoveBlacklistRules());
            jPopupMenu.add(item);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

