/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tasks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import mediathek.config.Daten;
import mediathek.config.StandardLocations;
import mediathek.filmlisten.writer.FilmListWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00012\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmediathek/gui/tasks/FilmlistWriterWorker;", "Ljavax/swing/SwingWorker;", "Ljava/lang/Void;", "", "Ljava/beans/PropertyChangeListener;", "progLabel", "Ljavax/swing/JLabel;", "progressBar", "Ljavax/swing/JProgressBar;", "<init>", "(Ljavax/swing/JLabel;Ljavax/swing/JProgressBar;)V", "doInBackground", "propertyChange", "", "evt", "Ljava/beans/PropertyChangeEvent;", "MediathekView"})
public final class FilmlistWriterWorker
extends SwingWorker<Void, Integer>
implements PropertyChangeListener {
    @NotNull
    private final JProgressBar progressBar;

    public FilmlistWriterWorker(@NotNull JLabel progLabel, @NotNull JProgressBar progressBar) {
        Intrinsics.checkNotNullParameter((Object)progLabel, (String)"progLabel");
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"progressBar");
        this.progressBar = progressBar;
        this.addPropertyChangeListener(this);
        SwingUtilities.invokeLater(() -> FilmlistWriterWorker._init_$lambda$0(progLabel, this));
    }

    @Override
    @Nullable
    protected Void doInBackground() {
        FilmListWriter writer = new FilmListWriter(false);
        writer.writeFilmList(StandardLocations.getFilmlistFilePathString(), Daten.getInstance().getListeFilme(), arg_0 -> FilmlistWriterWorker.doInBackground$lambda$1(this, arg_0));
        return null;
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (StringsKt.equals((String)evt.getPropertyName(), (String)"progress", (boolean)true)) {
            SwingUtilities.invokeLater(() -> FilmlistWriterWorker.propertyChange$lambda$2(this, evt));
        }
    }

    private static final void _init_$lambda$0(JLabel $progLabel, FilmlistWriterWorker this$0) {
        $progLabel.setText("Schreibe Filmliste");
        this$0.progressBar.setIndeterminate(false);
        this$0.progressBar.setMinimum(0);
        this$0.progressBar.setMaximum(100);
        this$0.progressBar.setValue(0);
    }

    private static final void doInBackground$lambda$1(FilmlistWriterWorker this$0, double prog) {
        this$0.setProgress(MathKt.roundToInt((double)(100.0 * prog)));
    }

    private static final void propertyChange$lambda$2(FilmlistWriterWorker this$0, PropertyChangeEvent $evt) {
        JProgressBar jProgressBar = this$0.progressBar;
        Object object = $evt.getNewValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        jProgressBar.setValue((Integer)object);
    }
}

