/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.config.MVConfig;
import mediathek.gui.messages.ProgramLocationChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.TextCopyPasteHandler;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.VerticalLayout;

public class PanelEinstellungenErweitert
extends JPanel {
    private static final Logger logger = LogManager.getLogger();
    private JCheckBox jCheckBoxAboSuchen;
    private JCheckBox jCheckBoxDownloadSofortStarten;
    private JTextField jTextFieldProgrammDateimanager;
    private JButton jButtonProgrammDateimanager;
    private JTextField jTextFieldVideoplayer;
    private JButton jButtonProgrammVideoplayer;
    private JTextField jTextFieldProgrammUrl;
    private JButton jButtonProgrammUrl;
    private JButton jButtonProgrammShutdown;
    private JTextField jTextFieldProgrammShutdown;

    @Handler
    private void handleProgramLocationChangedEvent(ProgramLocationChangedEvent e) {
        SwingUtilities.invokeLater(this::init);
    }

    public PanelEinstellungenErweitert() {
        this.initComponents();
        this.init();
        this.setIcon();
        this.jCheckBoxAboSuchen.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN)));
        this.jCheckBoxAboSuchen.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN, Boolean.toString(this.jCheckBoxAboSuchen.isSelected())));
        this.jCheckBoxDownloadSofortStarten.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DOWNLOAD_SOFORT_STARTEN)));
        this.jCheckBoxDownloadSofortStarten.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_DOWNLOAD_SOFORT_STARTEN, Boolean.toString(this.jCheckBoxDownloadSofortStarten.isSelected())));
        this.jButtonProgrammDateimanager.addActionListener(new BeobPfad(MVConfig.Configs.SYSTEM_ORDNER_OEFFNEN, "Dateimanager suchen", this.jTextFieldProgrammDateimanager));
        this.jButtonProgrammVideoplayer.addActionListener(new BeobPfad(MVConfig.Configs.SYSTEM_PLAYER_ABSPIELEN, "Videoplayer suchen", this.jTextFieldVideoplayer));
        this.jButtonProgrammUrl.addActionListener(new BeobPfad(MVConfig.Configs.SYSTEM_URL_OEFFNEN, "Browser suchen", this.jTextFieldProgrammUrl));
        this.jButtonProgrammShutdown.addActionListener(new BeobPfad(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN, "Shutdown Befehl", this.jTextFieldProgrammShutdown));
        this.jTextFieldProgrammDateimanager.setText(MVConfig.get(MVConfig.Configs.SYSTEM_ORDNER_OEFFNEN));
        this.jTextFieldProgrammDateimanager.getDocument().addDocumentListener(new BeobDoc(MVConfig.Configs.SYSTEM_ORDNER_OEFFNEN, this.jTextFieldProgrammDateimanager));
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgrammDateimanager);
        this.jTextFieldProgrammDateimanager.setComponentPopupMenu(handler.getPopupMenu());
        this.jTextFieldVideoplayer.setText(MVConfig.get(MVConfig.Configs.SYSTEM_PLAYER_ABSPIELEN));
        this.jTextFieldVideoplayer.getDocument().addDocumentListener(new BeobDoc(MVConfig.Configs.SYSTEM_PLAYER_ABSPIELEN, this.jTextFieldVideoplayer));
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldVideoplayer);
        this.jTextFieldVideoplayer.setComponentPopupMenu(handler.getPopupMenu());
        this.jTextFieldProgrammUrl.setText(this.getWebBrowserLocation());
        this.jTextFieldProgrammUrl.getDocument().addDocumentListener(new BeobDoc(MVConfig.Configs.SYSTEM_URL_OEFFNEN, this.jTextFieldProgrammUrl));
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgrammUrl);
        this.jTextFieldProgrammUrl.setComponentPopupMenu(handler.getPopupMenu());
        this.jTextFieldProgrammShutdown.setText(MVConfig.get(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN));
        if (this.jTextFieldProgrammShutdown.getText().isEmpty()) {
            this.jTextFieldProgrammShutdown.setText("shutdown -h now");
            MVConfig.add(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN, "shutdown -h now");
        }
        this.jTextFieldProgrammShutdown.getDocument().addDocumentListener(new BeobDoc(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN, this.jTextFieldProgrammShutdown));
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgrammShutdown);
        this.jTextFieldProgrammShutdown.setComponentPopupMenu(handler.getPopupMenu());
        if (!SystemUtils.IS_OS_LINUX) {
            this.jTextFieldProgrammShutdown.setEnabled(false);
            this.jButtonProgrammShutdown.setEnabled(false);
        }
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    private String getWebBrowserLocation() {
        return MVConfig.get(MVConfig.Configs.SYSTEM_URL_OEFFNEN);
    }

    private void init() {
        this.jTextFieldProgrammDateimanager.setText(MVConfig.get(MVConfig.Configs.SYSTEM_ORDNER_OEFFNEN));
        this.jTextFieldProgrammUrl.setText(this.getWebBrowserLocation());
    }

    private void setIcon() {
        FlatSVGIcon icon = SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg");
        this.jButtonProgrammDateimanager.setIcon((Icon)icon);
        this.jButtonProgrammVideoplayer.setIcon((Icon)icon);
        this.jButtonProgrammUrl.setIcon((Icon)icon);
        this.jButtonProgrammShutdown.setIcon((Icon)icon);
    }

    private void initComponents() {
        JPanel jPanel6 = new JPanel();
        this.jCheckBoxAboSuchen = new JCheckBox();
        this.jCheckBoxDownloadSofortStarten = new JCheckBox();
        JPanel jPanel2 = new JPanel();
        this.jTextFieldProgrammDateimanager = new JTextField();
        this.jButtonProgrammDateimanager = new JButton();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldVideoplayer = new JTextField();
        this.jButtonProgrammVideoplayer = new JButton();
        JPanel jPanel4 = new JPanel();
        this.jTextFieldProgrammUrl = new JTextField();
        this.jButtonProgrammUrl = new JButton();
        JPanel jPanel3 = new JPanel();
        this.jButtonProgrammShutdown = new JButton();
        this.jTextFieldProgrammShutdown = new JTextField();
        this.setLayout((LayoutManager)new VerticalLayout(5));
        jPanel6.setBorder(new TitledBorder("Nach dem Neuladen der Filmliste"));
        jPanel6.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().grow().fill(), new AC().fill().gap().fill()));
        this.jCheckBoxAboSuchen.setText("Abos automatisch suchen");
        this.jCheckBoxAboSuchen.setToolTipText("<html>Nach dem Neuladen einer Filmliste wird dann sofort nach neuen Abos gesucht.<br>Ansonsten muss man im Tab Download auf <i>Downloadliste aktualisieren</i> klicken.</html>");
        jPanel6.add((Component)this.jCheckBoxAboSuchen, new CC().cell(new int[]{0, 0}));
        this.jCheckBoxDownloadSofortStarten.setText("Downloads aus Abos sofort starten");
        this.jCheckBoxDownloadSofortStarten.setToolTipText("<html>Neu angelegte Downloads (aus Abos) werden sofort gestartet.<br>Ansonsten muss man sie selbst starten.</html>");
        jPanel6.add((Component)this.jCheckBoxDownloadSofortStarten, new CC().cell(new int[]{0, 1}));
        this.add(jPanel6);
        jPanel2.setBorder(new TitledBorder("Tab Downloads"));
        jPanel2.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().grow().fill().gap().fill(), new AC().fill().gap().fill().gap().fill().gap().fill()));
        this.jTextFieldProgrammDateimanager.setToolTipText("<html>Im Tab <i>Downloads</i> kann man mit der rechten Maustaste den Downloadordner (Zielordner) des jeweiligen Downloads \u00f6ffnen.<br>Normalerweise wird der Dateimanager des Betriebssystems gefunden und ge\u00f6ffnet.<br><br>Klappt das nicht, kann hier ein Programm daf\u00fcr angegeben werden.</html>");
        jPanel2.add((Component)this.jTextFieldProgrammDateimanager, new CC().cell(new int[]{0, 1}));
        this.jButtonProgrammDateimanager.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonProgrammDateimanager.setToolTipText("Programm ausw\u00e4hlen");
        jPanel2.add((Component)this.jButtonProgrammDateimanager, new CC().cell(new int[]{1, 1}));
        jLabel1.setText("Datei-Manager zum \u00d6ffnen des Downloadordners:");
        jPanel2.add((Component)jLabel1, new CC().cell(new int[]{0, 0, 2, 1}));
        jLabel2.setText("Videoplayer zum Abspielen gespeicherter Filme:");
        jPanel2.add((Component)jLabel2, new CC().cell(new int[]{0, 2, 2, 1}));
        this.jTextFieldVideoplayer.setToolTipText("<html>Im Tab <i>Downloads</i> kann man den gespeicherten Film in einem Videoplayer \u00f6ffnen.<br>Normalerweise wird der Videoplayer des Betriebssystems gefunden und ge\u00f6ffnet.<br>Klappt das nicht, kann hier ein Programm als Alternative angegeben werden.</html>");
        jPanel2.add((Component)this.jTextFieldVideoplayer, new CC().cell(new int[]{0, 3}));
        this.jButtonProgrammVideoplayer.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonProgrammVideoplayer.setToolTipText("Programm ausw\u00e4hlen");
        jPanel2.add((Component)this.jButtonProgrammVideoplayer, new CC().cell(new int[]{1, 3}));
        this.add(jPanel2);
        jPanel4.setBorder(new TitledBorder("Webbrowser zum \u00d6ffnen von URLs"));
        jPanel4.setToolTipText("<html>Wenn das Programm versucht, einen Link zu \u00f6ffnen und die Standardanwendung nicht startet, kann damit ein Programm ausgew\u00e4hlt und fest zugeordnet werden.</html>");
        jPanel4.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().grow().fill().gap().fill(), new AC().fill()));
        jPanel4.add((Component)this.jTextFieldProgrammUrl, new CC().cell(new int[]{0, 0}));
        this.jButtonProgrammUrl.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonProgrammUrl.setToolTipText("Programm ausw\u00e4hlen");
        jPanel4.add((Component)this.jButtonProgrammUrl, new CC().cell(new int[]{1, 0}));
        this.add(jPanel4);
        jPanel3.setBorder(new TitledBorder("Linux: Aufruf zum Shutdown"));
        jPanel3.setToolTipText("<html>Unter Linux wird das ausgew\u00e4hlte Programm/Script ausgef\u00fchrt um den Recher herunter zu fahren.<br>M\u00f6gliche Aufrufe sind:<br>\n<ul>\n<li>systemctl poweroff</li>\n<li>poweroff</li>\n<li>sudo shutdown -P now</li>\n<li><b>shutdown -h now</b></li>\n</ul>\n</html>");
        jPanel3.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().grow().fill().gap().fill(), new AC().fill()));
        this.jButtonProgrammShutdown.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonProgrammShutdown.setToolTipText("Programm/Script ausw\u00e4hlen");
        jPanel3.add((Component)this.jButtonProgrammShutdown, new CC().cell(new int[]{1, 0}));
        this.jTextFieldProgrammShutdown.setText("shutdown -h now");
        jPanel3.add((Component)this.jTextFieldProgrammShutdown, new CC().cell(new int[]{0, 0}));
        this.add(jPanel3);
    }

    private static class BeobPfad
    implements ActionListener {
        final MVConfig.Configs config;
        final String title;
        final JTextField textField;

        public BeobPfad(MVConfig.Configs config, String title, JTextField textField) {
            this.config = config;
            this.title = title;
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog((Frame)MediathekGui.ui(), this.title);
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        this.textField.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error("BeobPfad.actionPerformed", (Throwable)ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!this.textField.getText().isEmpty()) {
                    chooser.setCurrentDirectory(new File(this.textField.getText()));
                } else {
                    chooser.setCurrentDirectory(new File(SystemUtils.USER_HOME));
                }
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        this.textField.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error("BeobPfad.actionPerformed", (Throwable)ex);
                    }
                }
            }
            MVConfig.add(this.config, this.textField.getText());
            String programm = this.textField.getText();
            if (!programm.isEmpty()) {
                try {
                    if (!new File(programm).exists()) {
                        MVMessageDialog.showMessageDialog(MediathekGui.ui(), "Das Programm:  \"" + programm + "\"  existiert nicht!", "Fehler", 0);
                    } else if (!new File(programm).canExecute()) {
                        MVMessageDialog.showMessageDialog(MediathekGui.ui(), "Das Programm:  \"" + programm + "\"  kann nicht ausgef\u00fchrt werden!", "Fehler", 0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static class BeobDoc
    implements DocumentListener {
        final MVConfig.Configs config;
        final JTextField txt;

        public BeobDoc(MVConfig.Configs config, JTextField txt) {
            this.config = config;
            this.txt = txt;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            MVConfig.add(this.config, this.txt.getText());
        }
    }
}

