/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.attributes.FillRule;
import com.github.weisj.jsvg.geometry.AWTSVGShape;
import com.github.weisj.jsvg.geometry.FillRuleAwareAWTSVGShape;
import com.github.weisj.jsvg.geometry.MeasurableShape;
import com.github.weisj.jsvg.nodes.ShapeNode;
import com.github.weisj.jsvg.nodes.prototype.HasFillRule;
import com.github.weisj.jsvg.parser.AttributeNode;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPolyShape
extends ShapeNode
implements HasFillRule {
    private FillRule fillRule;

    @Override
    @NotNull
    public FillRule fillRule() {
        return this.fillRule;
    }

    @Override
    @NotNull
    protected final MeasurableShape buildShape(@NotNull AttributeNode attributeNode) {
        this.fillRule = FillRule.parse(attributeNode);
        float[] points = attributeNode.getFloatList("points");
        if (points.length > 0) {
            Path2D.Float path = new Path2D.Float(0, points.length / 2);
            ((Path2D)path).moveTo(points[0], points[1]);
            for (int i = 2; i < points.length; i += 2) {
                ((Path2D)path).lineTo(points[i], points[i + 1]);
            }
            if (this.doClose()) {
                path.closePath();
            }
            return new FillRuleAwareAWTSVGShape(path);
        }
        return new AWTSVGShape<Rectangle>(new Rectangle());
    }

    protected abstract boolean doClose();
}

