/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialSide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;

public class PartialGradientLineBorder
extends AbstractBorder
implements PartialSide {
    private int _sides = 15;
    private Color[] _colors;
    protected int _thickness;

    public PartialGradientLineBorder(Color[] colors) {
        this(colors, 1);
    }

    public PartialGradientLineBorder(Color[] colors, int thickness) {
        this(colors, thickness, 15);
    }

    public PartialGradientLineBorder(Color[] colors, int thickness, int sides) {
        if (colors.length < 2) {
            throw new IllegalArgumentException("Array \"colors\" should have at least 2 elements.");
        }
        this._colors = colors;
        this._thickness = thickness;
        this._sides = sides;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int sides) {
        this._sides = sides;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        Color oldColor = g2.getColor();
        Graphics2D g2d = (Graphics2D)g2;
        int i = 0;
        if ((this._sides & 1) != 0) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x, y, width, this._thickness), this._colors[i++], this._colors[i++], false);
        }
        if ((this._sides & 2) != 0) {
            if (i >= this._colors.length) {
                i -= 2;
            }
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x, y + height - this._thickness, width, this._thickness), this._colors[i++], this._colors[i++], false);
        }
        if ((this._sides & 8) != 0) {
            if (i >= this._colors.length) {
                i -= 2;
            }
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x, y, this._thickness, height), this._colors[i++], this._colors[i++], true);
        }
        if ((this._sides & 4) != 0) {
            if (i >= this._colors.length) {
                i -= 2;
            }
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x + width - this._thickness, y, this._thickness, height), this._colors[i++], this._colors[i], true);
        }
        g2.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets borderInsets = super.getBorderInsets(c);
        if ((this._sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets borderInsets = super.getBorderInsets(c, insets);
        if ((this._sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }
}

