/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.ysandbox;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.DateHighlightPolicy;
import com.github.lgooddatepicker.optionalusertools.DateVetoPolicy;
import com.github.lgooddatepicker.zinternaltools.HighlightInformation;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.time.DayOfWeek;
import java.time.LocalDate;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class TestStart {
    public static void main(String[] args2) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        frame.getContentPane().add(panel);
        DatePickerSettings dateSettings = new DatePickerSettings();
        DatePicker datePicker = new DatePicker(dateSettings);
        dateSettings.setVisibleDateTextField(false);
        dateSettings.setGapBeforeButtonPixels(0);
        datePicker.setBorder(LineBorder.createBlackLineBorder());
        panel.add(datePicker);
        frame.pack();
        frame.validate();
        int maxWidth = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width;
        int maxHeight = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height;
        frame.setSize(640, 480);
        frame.setLocation(maxWidth / 2, maxHeight / 2);
        frame.setVisible(true);
    }

    private static class SampleHighlightPolicy
    implements DateHighlightPolicy {
        private SampleHighlightPolicy() {
        }

        @Override
        public HighlightInformation getHighlightInformationOrNull(LocalDate date) {
            if (date.getDayOfMonth() == 25) {
                return new HighlightInformation(Color.red, null, "It's the 25th!");
            }
            if (date.getDayOfWeek() == DayOfWeek.SATURDAY) {
                return new HighlightInformation(Color.orange, Color.yellow, "It's Saturday!");
            }
            if (date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                return new HighlightInformation(null, null, "It's Sunday!");
            }
            return null;
        }
    }

    private static class SampleDateVetoPolicy
    implements DateVetoPolicy {
        private SampleDateVetoPolicy() {
        }

        @Override
        public boolean isDateAllowed(LocalDate date) {
            if (date.getDayOfMonth() >= 7 && date.getDayOfMonth() <= 11) {
                return false;
            }
            return date.getDayOfWeek() != DayOfWeek.SATURDAY || date.getDayOfMonth() % 2 != 1;
        }
    }
}

