/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.objectweb.asm.ClassVisitor;

public final class BytecodeTransformerBuildItem
extends MultiBuildItem {
    final String classToTransform;
    final BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction;
    final BiFunction<String, byte[], byte[]> inputTransformer;
    final Set<String> requireConstPoolEntry;
    final boolean cacheable;
    final int classReaderOptions;
    final boolean continueOnFailure;
    final int priority;

    public BytecodeTransformerBuildItem(String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction) {
        this(classToTransform, visitorFunction, null);
    }

    public BytecodeTransformerBuildItem(String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction, Set<String> requireConstPoolEntry) {
        this(false, classToTransform, visitorFunction, requireConstPoolEntry);
    }

    public BytecodeTransformerBuildItem(boolean eager, String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction) {
        this(eager, classToTransform, visitorFunction, null);
    }

    public BytecodeTransformerBuildItem(boolean eager, String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction, boolean cacheable) {
        this(eager, classToTransform, visitorFunction, null, cacheable);
    }

    public BytecodeTransformerBuildItem(boolean eager, String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction, Set<String> requireConstPoolEntry) {
        this(eager, classToTransform, visitorFunction, requireConstPoolEntry, false);
    }

    public BytecodeTransformerBuildItem(boolean eager, String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction, Set<String> requireConstPoolEntry, boolean cacheable) {
        Objects.requireNonNull(visitorFunction, "visitorFunction");
        this.classToTransform = classToTransform;
        this.visitorFunction = visitorFunction;
        this.requireConstPoolEntry = requireConstPoolEntry;
        this.cacheable = cacheable;
        this.inputTransformer = null;
        this.classReaderOptions = 0;
        this.continueOnFailure = false;
        this.priority = 0;
    }

    public BytecodeTransformerBuildItem(Builder builder) {
        this.classToTransform = builder.classToTransform;
        this.visitorFunction = builder.visitorFunction;
        this.requireConstPoolEntry = builder.requireConstPoolEntry;
        this.cacheable = builder.cacheable;
        this.inputTransformer = builder.inputTransformer;
        this.classReaderOptions = builder.classReaderOptions;
        this.continueOnFailure = builder.continueOnFailure;
        this.priority = builder.priority;
        if (this.visitorFunction == null && this.inputTransformer == null) {
            throw new IllegalArgumentException("One of either visitorFunction or inputTransformer must be set");
        }
    }

    public String getClassToTransform() {
        return this.classToTransform;
    }

    public BiFunction<String, ClassVisitor, ClassVisitor> getVisitorFunction() {
        return this.visitorFunction;
    }

    public Set<String> getRequireConstPoolEntry() {
        return this.requireConstPoolEntry;
    }

    @Deprecated(since="3.11", forRemoval=true)
    public boolean isEager() {
        return false;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public int getClassReaderOptions() {
        return this.classReaderOptions;
    }

    public BiFunction<String, byte[], byte[]> getInputTransformer() {
        return this.inputTransformer;
    }

    public boolean isContinueOnFailure() {
        return this.continueOnFailure;
    }

    public int getPriority() {
        return this.priority;
    }

    public static class Builder {
        public BiFunction<String, byte[], byte[]> inputTransformer;
        public boolean continueOnFailure;
        private String classToTransform;
        private BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction;
        private Set<String> requireConstPoolEntry = null;
        private boolean cacheable = false;
        private int classReaderOptions = 0;
        private int priority = 0;

        public Builder setContinueOnFailure(boolean continueOnFailure) {
            this.continueOnFailure = continueOnFailure;
            return this;
        }

        public Builder setInputTransformer(BiFunction<String, byte[], byte[]> inputTransformer) {
            this.inputTransformer = inputTransformer;
            return this;
        }

        public Builder setClassToTransform(String classToTransform) {
            this.classToTransform = classToTransform;
            return this;
        }

        public Builder setVisitorFunction(BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction) {
            this.visitorFunction = visitorFunction;
            return this;
        }

        public Builder setRequireConstPoolEntry(Set<String> requireConstPoolEntry) {
            this.requireConstPoolEntry = requireConstPoolEntry;
            return this;
        }

        @Deprecated(since="3.11", forRemoval=true)
        public Builder setEager(boolean eager) {
            return this;
        }

        public Builder setCacheable(boolean cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public Builder setClassReaderOptions(int classReaderOptions) {
            this.classReaderOptions = classReaderOptions;
            return this;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public BytecodeTransformerBuildItem build() {
            return new BytecodeTransformerBuildItem(this);
        }
    }
}

