/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.bitbucket;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.simple.SimpleHttp;
import org.keycloak.http.simple.SimpleHttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.ErrorResponseException;

public class BitbucketIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    public static final String AUTH_URL = "https://bitbucket.org/site/oauth2/authorize";
    public static final String TOKEN_URL = "https://bitbucket.org/site/oauth2/access_token";
    public static final String USER_URL = "https://api.bitbucket.org/2.0/user";
    public static final String USER_EMAIL_URL = "https://api.bitbucket.org/2.0/user/emails";
    public static final String EMAIL_SCOPE = "email";
    public static final String ACCOUNT_SCOPE = "account";
    public static final String DEFAULT_SCOPE = "account";

    public BitbucketIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        String defaultScope = config.getDefaultScope();
        if (defaultScope == null || defaultScope.trim().equals("")) {
            config.setDefaultScope("account email");
        }
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        return USER_URL;
    }

    @Override
    protected BrokeredIdentityContext validateExternalTokenThroughUserInfo(EventBuilder event, String subjectToken, String subjectTokenType) {
        event.detail("validation_method", "user info");
        SimpleHttpResponse response = null;
        int status = 0;
        try {
            String userInfoUrl = this.getProfileEndpointForValidation(event);
            response = this.buildUserInfoRequest(subjectToken, userInfoUrl).asResponse();
            status = response.getStatus();
        }
        catch (IOException e) {
            logger.debug((Object)"Failed to invoke user info for external exchange", (Throwable)e);
        }
        if (status != 200) {
            logger.debug((Object)("Failed to invoke user info status: " + status));
            event.detail("reason", "user info call failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        JsonNode profile = null;
        try {
            profile = response.asJson();
        }
        catch (IOException e) {
            event.detail("reason", "user info call failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        String type = this.getJsonProperty(profile, "type");
        if (type == null) {
            event.detail("reason", "no type data in user info response");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        if (type.equals("error")) {
            JsonNode errorNode = profile.get("error");
            if (errorNode != null) {
                String errorMsg = this.getJsonProperty(errorNode, "message");
                event.detail("reason", "user info call failure: " + errorMsg);
                event.error("invalid_token");
                throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
            }
            event.detail("reason", "user info call failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        if (!type.equals("user")) {
            event.detail("reason", "no user info in response");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        String id = this.getJsonProperty(profile, "account_id");
        if (id == null) {
            event.detail("reason", "user info call failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        return this.extractUserInfo(subjectToken, profile);
    }

    private BrokeredIdentityContext extractUserInfo(String subjectToken, JsonNode profile) {
        BrokeredIdentityContext user = new BrokeredIdentityContext(this.getJsonProperty(profile, "account_id"), this.getConfig());
        String username = this.getJsonProperty(profile, "username");
        user.setUsername(username);
        user.setName(this.getJsonProperty(profile, "display_name"));
        user.setIdp((IdentityProvider)this);
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
        try {
            JsonNode emails = SimpleHttp.create((KeycloakSession)this.session).doGet(USER_EMAIL_URL).header("Authorization", "Bearer " + subjectToken).asJson();
            JsonNode emailJson = emails.get("values");
            if (emailJson != null) {
                if (emailJson.isArray()) {
                    emailJson = emailJson.get(0);
                }
                if (emailJson != null && EMAIL_SCOPE.equals(this.getJsonProperty(emailJson, "type"))) {
                    user.setEmail(this.getJsonProperty(emailJson, EMAIL_SCOPE));
                }
            }
        }
        catch (Exception ignore) {
            logger.debug((Object)"failed to get email from BitBucket", (Throwable)ignore);
        }
        return user;
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = SimpleHttp.create((KeycloakSession)this.session).doGet(USER_URL).header("Authorization", "Bearer " + accessToken).asJson();
            String type = this.getJsonProperty(profile, "type");
            if (type == null) {
                throw new IdentityBrokerException("Could not obtain account information from bitbucket.");
            }
            if (type.equals("error")) {
                JsonNode errorNode = profile.get("error");
                if (errorNode != null) {
                    String errorMsg = this.getJsonProperty(errorNode, "message");
                    throw new IdentityBrokerException("Could not obtain account information from bitbucket.  Error: " + errorMsg);
                }
                throw new IdentityBrokerException("Could not obtain account information from bitbucket.");
            }
            if (!type.equals("user")) {
                logger.debug((Object)("Unknown object type: " + type));
                throw new IdentityBrokerException("Could not obtain account information from bitbucket.");
            }
            return this.extractUserInfo(accessToken, profile);
        }
        catch (Exception e) {
            if (e instanceof IdentityBrokerException) {
                throw (IdentityBrokerException)((Object)e);
            }
            throw new IdentityBrokerException("Could not obtain user profile from bitbucket.", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return "account";
    }
}

