/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import org.hibernate.AssertionFailure;
import org.hibernate.id.enhanced.CustomOptimizerDescriptor;
import org.hibernate.id.enhanced.HiLoOptimizer;
import org.hibernate.id.enhanced.LegacyHiLoAlgorithmOptimizer;
import org.hibernate.id.enhanced.NoopOptimizer;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerDescriptor;
import org.hibernate.id.enhanced.PooledLoOptimizer;
import org.hibernate.id.enhanced.PooledLoThreadLocalOptimizer;
import org.hibernate.id.enhanced.PooledOptimizer;
import org.hibernate.internal.util.StringHelper;

public enum StandardOptimizerDescriptor implements OptimizerDescriptor
{
    NONE,
    HILO,
    LEGACY_HILO,
    POOLED,
    POOLED_LO,
    POOLED_LOTL;


    @Override
    public String getExternalName() {
        switch (this.ordinal()) {
            case 0: {
                return "none";
            }
            case 1: {
                return "hilo";
            }
            case 2: {
                return "legacy-hilo";
            }
            case 3: {
                return "pooled";
            }
            case 4: {
                return "pooled-lo";
            }
            case 5: {
                return "pooled-lotl";
            }
        }
        throw new AssertionFailure("unknown StandardOptimizerDescriptor");
    }

    @Override
    public Class<? extends Optimizer> getOptimizerClass() {
        switch (this.ordinal()) {
            case 0: {
                return NoopOptimizer.class;
            }
            case 1: {
                return HiLoOptimizer.class;
            }
            case 2: {
                return LegacyHiLoAlgorithmOptimizer.class;
            }
            case 3: {
                return PooledOptimizer.class;
            }
            case 4: {
                return PooledLoOptimizer.class;
            }
            case 5: {
                return PooledLoThreadLocalOptimizer.class;
            }
        }
        throw new AssertionFailure("unknown StandardOptimizerDescriptor");
    }

    @Override
    public boolean isPooled() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        throw new AssertionFailure("unknown StandardOptimizerDescriptor");
    }

    public static OptimizerDescriptor fromExternalName(String externalName) {
        if (StringHelper.isEmpty(externalName)) {
            return NONE;
        }
        for (StandardOptimizerDescriptor value : StandardOptimizerDescriptor.values()) {
            if (!value.getExternalName().equals(externalName)) continue;
            return value;
        }
        return new CustomOptimizerDescriptor(externalName);
    }
}

