/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.spi;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Objects;
import java.util.function.Supplier;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.spi.SQLExceptionLogging;
import org.hibernate.exception.internal.SQLStateConversionDelegate;
import org.hibernate.exception.internal.StandardSQLExceptionConverter;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.jboss.logging.Logger;

public class SqlExceptionHelper {
    private final boolean logWarnings;
    private final boolean logErrors;
    private static final SQLExceptionConverter DEFAULT_CONVERTER = new StandardSQLExceptionConverter(new SQLStateConversionDelegate(() -> e -> null));
    private SQLExceptionConverter sqlExceptionConverter;
    public static final StandardWarningHandler STANDARD_WARNING_HANDLER = new StandardWarningHandler("SQL Warning");

    public SqlExceptionHelper(boolean logWarnings) {
        this(DEFAULT_CONVERTER, logWarnings);
    }

    public SqlExceptionHelper(boolean logWarnings, boolean logErrors) {
        this(DEFAULT_CONVERTER, logWarnings, logErrors);
    }

    public SqlExceptionHelper(SQLExceptionConverter sqlExceptionConverter, boolean logWarnings) {
        this(sqlExceptionConverter, logWarnings, true);
    }

    public SqlExceptionHelper(SQLExceptionConverter sqlExceptionConverter, boolean logWarnings, boolean logErrors) {
        this.sqlExceptionConverter = sqlExceptionConverter;
        this.logWarnings = logWarnings;
        this.logErrors = logErrors;
    }

    public SQLExceptionConverter getSqlExceptionConverter() {
        return this.sqlExceptionConverter;
    }

    public void setSqlExceptionConverter(SQLExceptionConverter sqlExceptionConverter) {
        this.sqlExceptionConverter = sqlExceptionConverter == null ? DEFAULT_CONVERTER : sqlExceptionConverter;
    }

    public JDBCException convert(SQLException sqlException, String message) {
        return this.convert(sqlException, message, "n/a");
    }

    public JDBCException convert(SQLException sqlException, String message, String sql) {
        this.logExceptions(sqlException, message + " [" + sql + "]");
        return this.sqlExceptionConverter.convert(sqlException, message + " [" + sqlException.getMessage() + "]", sql);
    }

    public JDBCException convert(SQLException sqlException, Supplier<String> messageSupplier, String sql) {
        return this.convert(sqlException, messageSupplier.get(), sql);
    }

    public void logExceptions(SQLException sqlException, String message) {
        if (this.logErrors) {
            if (SQLExceptionLogging.ERROR_LOG.isEnabled(Logger.Level.WARN)) {
                for (SQLException currentException = sqlException; currentException != null; currentException = currentException.getNextException()) {
                    if (SqlExceptionHelper.isDuplicate(currentException, sqlException)) continue;
                    SQLExceptionLogging.ERROR_LOG.logErrorCodes(sqlException.getErrorCode(), sqlException.getSQLState());
                    SQLExceptionLogging.ERROR_LOG.warn(sqlException.getMessage());
                }
            }
            if (SQLExceptionLogging.ERROR_LOG.isDebugEnabled()) {
                SQLExceptionLogging.ERROR_LOG.debug(message, sqlException);
            }
        }
    }

    private static boolean isDuplicate(SQLException currentException, SQLException baseException) {
        for (SQLException previousException = baseException; previousException != currentException && previousException != null; previousException = previousException.getNextException()) {
            if (previousException.getErrorCode() != currentException.getErrorCode() || !Objects.equals(previousException.getSQLState(), currentException.getSQLState()) || !Objects.equals(previousException.getMessage(), currentException.getMessage())) continue;
            return true;
        }
        return false;
    }

    public void walkWarnings(SQLWarning warning, WarningHandler handler) {
        if (warning != null && handler.doProcess()) {
            handler.prepare(warning);
            while (warning != null) {
                handler.handleWarning(warning);
                warning = warning.getNextWarning();
            }
        }
    }

    public void logAndClearWarnings(Connection connection) {
        this.handleAndClearWarnings(connection, (WarningHandler)STANDARD_WARNING_HANDLER);
    }

    public void logAndClearWarnings(Statement statement) {
        this.handleAndClearWarnings(statement, (WarningHandler)STANDARD_WARNING_HANDLER);
    }

    public void handleAndClearWarnings(Connection connection, WarningHandler handler) {
        try {
            if (this.logWarnings) {
                this.walkWarnings(connection.getWarnings(), handler);
            }
        }
        catch (SQLException sqle) {
            SQLExceptionLogging.WARNING_LOG.debug("could not log warnings", sqle);
        }
        try {
            connection.clearWarnings();
        }
        catch (SQLException sqle) {
            SQLExceptionLogging.WARNING_LOG.debug("could not clear warnings", sqle);
        }
    }

    public void handleAndClearWarnings(Statement statement, WarningHandler handler) {
        if (this.logWarnings) {
            try {
                this.walkWarnings(statement.getWarnings(), handler);
            }
            catch (SQLException sqlException) {
                SQLExceptionLogging.WARNING_LOG.debug("could not log warnings", sqlException);
            }
        }
        try {
            statement.clearWarnings();
        }
        catch (SQLException sqle) {
            SQLExceptionLogging.WARNING_LOG.debug("could not clear warnings", sqle);
        }
    }

    public static interface WarningHandler {
        public boolean doProcess();

        public void prepare(SQLWarning var1);

        public void handleWarning(SQLWarning var1);
    }

    public static class StandardWarningHandler
    extends WarningHandlerLoggingSupport {
        private final String introMessage;

        public StandardWarningHandler(String introMessage) {
            this.introMessage = introMessage;
        }

        @Override
        public boolean doProcess() {
            return SQLExceptionLogging.WARNING_LOG.isEnabled(Logger.Level.WARN);
        }

        @Override
        public void prepare(SQLWarning warning) {
            SQLExceptionLogging.WARNING_LOG.debug(this.introMessage, warning);
        }

        @Override
        public final void handleWarning(SQLWarning warning) {
            SQLExceptionLogging.WARNING_LOG.logErrorCodes(warning.getErrorCode(), warning.getSQLState());
            SQLExceptionLogging.WARNING_LOG.warn(warning.getMessage());
        }

        @Override
        protected void logWarning(String description, String message) {
            SQLExceptionLogging.WARNING_LOG.warn(description);
            SQLExceptionLogging.WARNING_LOG.warn(message);
        }
    }

    public static abstract class WarningHandlerLoggingSupport
    implements WarningHandler {
        @Override
        public void handleWarning(SQLWarning warning) {
            this.logWarning("SQL Warning Code: " + warning.getErrorCode() + ", SQLState: " + warning.getSQLState(), warning.getMessage());
        }

        protected abstract void logWarning(String var1, String var2);
    }
}

