/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi.page;

import io.quarkus.devui.spi.page.AssistantPageBuilder;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.QuteDataPageBuilder;
import io.quarkus.devui.spi.page.RawDataPageBuilder;
import io.quarkus.devui.spi.page.TableDataPageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class Page {
    private final String icon;
    private final String color;
    private final String tooltip;
    private final String title;
    private final String staticLabel;
    private final String dynamicLabel;
    private final String streamingLabel;
    private final String streamingLabelParams;
    private final String componentName;
    private final String componentLink;
    private final Map<String, String> metadata;
    private final boolean embed;
    private final boolean includeInMenu;
    private final boolean internalComponent;
    private String namespace = null;
    private String namespaceLabel = null;
    private String extensionId = null;
    private String menuActionComponent = null;
    private static final String SPACE = " ";
    private static final String DASH = "-";
    private static final String SLASH = "/";
    private static final String DOT = ".";

    protected Page(String icon, String color, String tooltip, String title, String staticLabel, String dynamicLabel, String streamingLabel, String[] streamingLabelParams, String componentName, String componentLink, Map<String, String> metadata, boolean embed, boolean includeInMenu, boolean internalComponent, String namespace, String namespaceLabel, String extensionId) {
        this.icon = icon != null ? icon : "font-awesome-solid:arrow-right";
        this.color = color != null ? color : "var(--lumo-contrast-80pct)";
        this.tooltip = tooltip;
        this.title = title;
        this.staticLabel = staticLabel;
        this.dynamicLabel = dynamicLabel;
        this.streamingLabel = streamingLabel;
        this.streamingLabelParams = streamingLabelParams != null && streamingLabelParams.length > 0 ? String.join((CharSequence)",", streamingLabelParams) : null;
        this.componentName = componentName;
        this.componentLink = componentLink;
        this.metadata = metadata;
        this.embed = embed;
        this.includeInMenu = includeInMenu;
        this.internalComponent = internalComponent;
        this.namespace = namespace;
        this.namespaceLabel = namespaceLabel;
        this.extensionId = extensionId;
    }

    public String getId() {
        Object id = this.title.toLowerCase().replaceAll(SPACE, DASH);
        try {
            id = URLEncoder.encode((String)id, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        if (!this.isInternal() && this.namespace != null) {
            id = this.namespace.toLowerCase() + SLASH + (String)id;
        } else if (this.isInternal() && this.namespace != null) {
            String d = "devui-" + (String)id;
            if (d.equals(this.namespace)) {
                return id;
            }
            int i = this.namespace.indexOf(DASH) + 1;
            String stripDevui = this.namespace.substring(i);
            return stripDevui + DASH + (String)id;
        }
        return id;
    }

    public String getComponentRef() {
        if (this.internalComponent) {
            return "./../qwc/" + this.componentLink;
        }
        if (this.namespace != null) {
            return "./../" + this.namespace + SLASH + this.componentLink;
        }
        throw new RuntimeException("Could not find component reference");
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceLabel() {
        return this.namespaceLabel;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getColor() {
        return this.color;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean isAssistantPage() {
        return this.metadata != null && this.metadata.containsKey("isAssistantPage") && this.metadata.get("isAssistantPage").equalsIgnoreCase("true");
    }

    public String getTitle() {
        return this.title;
    }

    public String getStaticLabel() {
        return this.staticLabel;
    }

    public String getDynamicLabel() {
        return this.dynamicLabel;
    }

    public String getStreamingLabel() {
        return this.streamingLabel;
    }

    public String getStreamingLabelParams() {
        return this.streamingLabelParams;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentLink() {
        return this.componentLink;
    }

    public boolean isEmbed() {
        return this.embed;
    }

    public boolean isIncludeInMenu() {
        return this.includeInMenu;
    }

    public boolean isInternal() {
        return this.internalComponent && this.extensionId == null;
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMenuActionComponent(String menuActionComponent) {
        this.menuActionComponent = menuActionComponent;
    }

    public String getMenuActionComponent() {
        return this.menuActionComponent;
    }

    public String toString() {
        return "Page {\n\tid=" + this.getId() + ", \n\ticon=" + this.icon + ", \n\tcolor=" + this.color + ", \n\ttooltip=" + this.tooltip + ", \n\ttitle=" + this.title + ", \n\tstaticLabel=" + this.staticLabel + ", \n\tdynamicLabel=" + this.dynamicLabel + ", \n\tstreamingLabel=" + this.streamingLabel + ", \n\tstreamingLabelParams=" + this.streamingLabelParams + ", \n\tnamespace=" + this.namespace + ", \n\tnamespaceLabel=" + this.namespaceLabel + ", \n\tcomponentName=" + this.componentName + ", \n\tcomponentLink=" + this.componentLink + ", \n\tembed=" + this.embed + ", \n\tincludeInMenu=" + this.includeInMenu + "\n}";
    }

    public static WebComponentPageBuilder webComponentPageBuilder() {
        return new WebComponentPageBuilder();
    }

    public static WebComponentPageBuilder assistantPageBuilder() {
        return new AssistantPageBuilder();
    }

    public static ExternalPageBuilder externalPageBuilder(String name) {
        return new ExternalPageBuilder(name);
    }

    public static RawDataPageBuilder rawDataPageBuilder(String name) {
        return new RawDataPageBuilder(name);
    }

    public static QuteDataPageBuilder quteDataPageBuilder(String name) {
        return new QuteDataPageBuilder(name);
    }

    public static TableDataPageBuilder tableDataPageBuilder(String name) {
        return new TableDataPageBuilder(name);
    }
}

