/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions.util;

import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.common.util.Time;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.provider.ProviderConfigProperty;

public class EmailCooldownManager {
    private static final Logger logger = Logger.getLogger(EmailCooldownManager.class);
    public static final String EMAIL_RESEND_COOLDOWN_SECONDS = "emailResendCooldownSeconds";
    public static final int EMAIL_RESEND_COOLDOWN_DEFAULT_SECONDS = 30;
    private static final String KEY_EXPIRE = "expire";

    public static Long retrieveCooldownEntry(RequiredActionContext context, String keyPrefix) {
        SingleUseObjectProvider singleUseCache = context.getSession().singleUseObjects();
        Map cooldownDetails = singleUseCache.get(EmailCooldownManager.getCacheKey(context, keyPrefix));
        if (cooldownDetails == null) {
            return null;
        }
        long remaining = Long.parseLong((String)cooldownDetails.get(KEY_EXPIRE)) - (long)Time.currentTime();
        return remaining > 0L ? Long.valueOf(remaining) : null;
    }

    public static void addCooldownEntry(RequiredActionContext context, String keyPrefix) {
        SingleUseObjectProvider cache = context.getSession().singleUseObjects();
        long cooldownSeconds = EmailCooldownManager.getCooldownInSeconds(context);
        cache.put(EmailCooldownManager.getCacheKey(context, keyPrefix), cooldownSeconds, Map.of(KEY_EXPIRE, Long.toString((long)Time.currentTime() + cooldownSeconds)));
    }

    public static ProviderConfigProperty createCooldownConfigProperty() {
        ProviderConfigProperty cooldown = new ProviderConfigProperty();
        cooldown.setName(EMAIL_RESEND_COOLDOWN_SECONDS);
        cooldown.setLabel("Cooldown Between Email Resend (seconds)");
        cooldown.setHelpText("Minimum delay in seconds before another email verification email can be sent.");
        cooldown.setType("String");
        cooldown.setDefaultValue((Object)String.valueOf(30));
        return cooldown;
    }

    private static String getCacheKey(RequiredActionContext context, String keyPrefix) {
        return keyPrefix + context.getUser().getId();
    }

    private static long getCooldownInSeconds(RequiredActionContext context) {
        try {
            RequiredActionProviderModel model = context.getRealm().getRequiredActionProviderByAlias(context.getAction());
            if (model == null || model.getConfig() == null) {
                logger.warn((Object)("No RequiredActionProviderModel found for alias: " + context.getAction()));
                return 30L;
            }
            String value = model.getConfig().getOrDefault(EMAIL_RESEND_COOLDOWN_SECONDS, String.valueOf(30));
            return Long.parseLong(value);
        }
        catch (RuntimeException e) {
            logger.error((Object)"Failed to fetch cooldown from config: ", (Throwable)e);
            return 30L;
        }
    }
}

