/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryInfoKey;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={RecoveryManager.class})
public class RecoveryManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(RecoveryManagerFactory.class);
    private static final long DEFAULT_EXPIRY = TimeUnit.HOURS.toMillis(6L);

    @Override
    public Object construct(String name) {
        if (this.configuration.transaction().recovery().enabled()) {
            String recoveryCacheName = this.configuration.transaction().recovery().recoveryInfoCacheName();
            log.tracef("Using recovery cache name %s", recoveryCacheName);
            EmbeddedCacheManager cm = this.componentRegistry.getGlobalComponentRegistry().getComponent(EmbeddedCacheManager.class);
            boolean useDefaultCache = recoveryCacheName.equals("__recoveryInfoCacheName__");
            if (!useDefaultCache) {
                if (!cm.getCacheConfigurationNames().contains(recoveryCacheName)) {
                    throw new CacheConfigurationException("Recovery cache (" + recoveryCacheName + ") does not exist!!");
                }
            } else {
                InternalCacheRegistry internalCacheRegistry = this.componentRegistry.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
                internalCacheRegistry.registerInternalCache(recoveryCacheName, this.getDefaultRecoveryCacheConfig());
            }
            return this.buildRecoveryManager(this.componentRegistry.getCacheName(), recoveryCacheName, cm, useDefaultCache);
        }
        return null;
    }

    private Configuration getDefaultRecoveryCacheConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        builder.expiration().lifespan(DEFAULT_EXPIRY);
        builder.transaction().recovery().disable();
        return builder.build();
    }

    private RecoveryManager buildRecoveryManager(String cacheName, String recoveryCacheName, EmbeddedCacheManager cm, boolean isDefault) {
        log.tracef("About to obtain a reference to the recovery cache: %s", recoveryCacheName);
        BasicCache recoveryCache = cm.getCache(recoveryCacheName);
        if (recoveryCache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            throw new CacheConfigurationException("The recovery cache shouldn't be transactional.");
        }
        log.tracef("Obtained a reference to the recovery cache: %s", recoveryCacheName);
        return new RecoveryManagerImpl((ConcurrentMap<RecoveryInfoKey, RecoveryAwareRemoteTransaction>)recoveryCache, cacheName);
    }
}

