/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public final class ServiceLoaderSaslServerFactory
implements SaslServerFactory {
    private final ServiceLoader<SaslServerFactory> loader;

    public ServiceLoaderSaslServerFactory(ServiceLoader<SaslServerFactory> loader) {
        this.loader = loader;
    }

    public ServiceLoaderSaslServerFactory(ClassLoader classLoader) {
        this(ServiceLoader.load(SaslServerFactory.class, classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        ServiceLoader<SaslServerFactory> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            Iterator<SaslServerFactory> iterator = this.loader.iterator();
            while (true) {
                try {
                    while (iterator.hasNext()) {
                        SaslServerFactory serverFactory = iterator.next();
                        SaslServer saslServer = serverFactory.createSaslServer(mechanism, protocol, serverName, props, cbh);
                        if (saslServer == null) continue;
                        return saslServer;
                    }
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    continue;
                }
                break;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        ServiceLoader<SaslServerFactory> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            LinkedHashSet set = new LinkedHashSet();
            Iterator<SaslServerFactory> iterator = this.loader.iterator();
            while (true) {
                try {
                    while (iterator.hasNext()) {
                        SaslServerFactory serverFactory = iterator.next();
                        Collections.addAll(set, serverFactory.getMechanismNames(props));
                    }
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    continue;
                }
                break;
            }
            return set.toArray(new String[set.size()]);
        }
    }
}

