/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyStandard;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class OffsetFetchLimitHandler
extends AbstractLimitHandler {
    public static final OffsetFetchLimitHandler INSTANCE = new OffsetFetchLimitHandler(true);
    private final boolean variableLimit;

    public OffsetFetchLimitHandler(boolean variableLimit) {
        this.variableLimit = variableLimit;
    }

    @Override
    public String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, QueryOptions queryOptions) {
        return this.processSql(sql, jdbcParameterCount, parameterMarkerStrategy, queryOptions.getLimit());
    }

    @Override
    public String processSql(String sql, Limit limit) {
        return this.processSql(sql, -1, null, limit);
    }

    private String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, @Nullable Limit limit) {
        boolean hasFirstRow = OffsetFetchLimitHandler.hasFirstRow(limit);
        boolean hasMaxRows = OffsetFetchLimitHandler.hasMaxRows(limit);
        if (!hasFirstRow && !hasMaxRows) {
            return sql;
        }
        StringBuilder offsetFetch = new StringBuilder();
        this.begin(sql, offsetFetch, hasFirstRow, hasMaxRows);
        if (hasFirstRow) {
            offsetFetch.append(" offset ");
            if (this.supportsVariableLimit()) {
                if (ParameterMarkerStrategyStandard.isStandardRenderer(parameterMarkerStrategy)) {
                    offsetFetch.append("?");
                } else {
                    offsetFetch.append(parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null));
                }
            } else {
                offsetFetch.append(limit.getFirstRow());
            }
            if (this.renderOffsetRowsKeyword()) {
                offsetFetch.append(" rows");
            }
        }
        if (hasMaxRows) {
            if (hasFirstRow) {
                offsetFetch.append(" fetch next ");
            } else {
                offsetFetch.append(" fetch first ");
            }
            if (this.supportsVariableLimit()) {
                if (ParameterMarkerStrategyStandard.isStandardRenderer(parameterMarkerStrategy)) {
                    offsetFetch.append("?");
                } else {
                    offsetFetch.append(parameterMarkerStrategy.createMarker(jdbcParameterCount + (hasFirstRow ? 2 : 1), null));
                }
            } else {
                offsetFetch.append(this.getMaxOrLimit(limit));
            }
            offsetFetch.append(" rows only");
        }
        return this.insert(offsetFetch.toString(), sql);
    }

    void begin(String sql, StringBuilder offsetFetch, boolean hasFirstRow, boolean hasMaxRows) {
    }

    String insert(String offsetFetch, String sql) {
        return this.insertBeforeForUpdate(offsetFetch, sql);
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public final boolean supportsVariableLimit() {
        return this.variableLimit;
    }

    protected boolean renderOffsetRowsKeyword() {
        return true;
    }

    @Override
    public boolean processSqlMutatesState() {
        return false;
    }
}

