/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.ComparableExecutable;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PreCollectionUpdateEvent;
import org.hibernate.event.spi.PreCollectionUpdateEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.stat.spi.StatisticsImplementor;

public final class CollectionUpdateAction
extends CollectionAction {
    private final boolean emptySnapshot;

    public CollectionUpdateAction(PersistentCollection<?> collection, CollectionPersister persister, Object id, boolean emptySnapshot, EventSource session) {
        super(persister, collection, id, session);
        this.emptySnapshot = emptySnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws HibernateException {
        Object key = this.getKey();
        EventSource session = this.getSession();
        CollectionPersister persister = this.getPersister();
        PersistentCollection<?> collection = this.getCollection();
        boolean affectedByFilters = persister.isAffectedByEnabledFilters(session);
        this.preUpdate();
        if (!collection.wasInitialized()) {
            if (!collection.isDirty()) {
                throw new AssertionFailure("collection is not dirty");
            }
        } else {
            EventMonitor eventMonitor = session.getEventMonitor();
            DiagnosticEvent event = eventMonitor.beginCollectionUpdateEvent();
            boolean success = false;
            try {
                if (!affectedByFilters && collection.empty()) {
                    if (!this.emptySnapshot) {
                        persister.remove(key, session);
                    }
                } else if (collection.needsRecreate(persister)) {
                    if (affectedByFilters) {
                        throw new HibernateException("cannot recreate collection while filter is enabled: " + MessageHelper.collectionInfoString(persister, collection, key, session));
                    }
                    if (!this.emptySnapshot) {
                        persister.remove(key, session);
                    }
                    persister.recreate(collection, key, session);
                } else {
                    persister.deleteRows(collection, key, session);
                    persister.updateRows(collection, key, session);
                    persister.insertRows(collection, key, session);
                }
                success = true;
            }
            finally {
                eventMonitor.completeCollectionUpdateEvent(event, key, persister.getRole(), success, session);
            }
        }
        session.getPersistenceContextInternal().getCollectionEntry(collection).afterAction(collection);
        this.evict();
        this.postUpdate();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.updateCollection(persister.getRole());
        }
    }

    @Override
    public int compareTo(ComparableExecutable executable) {
        if (executable instanceof CollectionUpdateAction) {
            CollectionUpdateAction that = (CollectionUpdateAction)executable;
            if (this.getPrimarySortClassifier().equals(executable.getPrimarySortClassifier())) {
                CollectionPersister persister = this.getPersister();
                boolean hasDeletes = this.getCollection().hasDeletes(persister);
                boolean otherHasDeletes = that.getCollection().hasDeletes(persister);
                if (hasDeletes && !otherHasDeletes) {
                    return -1;
                }
                if (otherHasDeletes && !hasDeletes) {
                    return 1;
                }
            }
        }
        return super.compareTo(executable);
    }

    private void preUpdate() {
        this.getEventListenerGroups().eventListenerGroup_PRE_COLLECTION_UPDATE.fireLazyEventOnEachListener(this::newPreCollectionUpdateEvent, PreCollectionUpdateEventListener::onPreUpdateCollection);
    }

    private PreCollectionUpdateEvent newPreCollectionUpdateEvent() {
        return new PreCollectionUpdateEvent(this.getPersister(), this.getCollection(), this.eventSource());
    }

    private void postUpdate() {
        this.getEventListenerGroups().eventListenerGroup_POST_COLLECTION_UPDATE.fireLazyEventOnEachListener(this::newPostCollectionUpdateEvent, PostCollectionUpdateEventListener::onPostUpdateCollection);
    }

    private PostCollectionUpdateEvent newPostCollectionUpdateEvent() {
        return new PostCollectionUpdateEvent(this.getPersister(), this.getCollection(), this.eventSource());
    }
}

