/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.cache.spi.Region;
import org.infinispan.quarkus.hibernate.cache.InternalRegion;
import org.jboss.logging.Logger;

final class InternalRegionImpl
implements InternalRegion {
    private static final Logger log = Logger.getLogger(InternalRegionImpl.class);
    private final Region region;
    private volatile long lastRegionInvalidation = Long.MIN_VALUE;
    private int invalidations = 0;
    private final Map<String, Comparator<Object>> comparatorsByType = new HashMap<String, Comparator<Object>>();

    InternalRegionImpl(Region region) {
        this.region = region;
    }

    @Override
    public boolean checkValid() {
        return this.lastRegionInvalidation != Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginInvalidation() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Begin invalidating region: " + this.region.getName()));
        }
        InternalRegionImpl internalRegionImpl = this;
        synchronized (internalRegionImpl) {
            this.lastRegionInvalidation = Long.MAX_VALUE;
            ++this.invalidations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endInvalidation() {
        InternalRegionImpl internalRegionImpl = this;
        synchronized (internalRegionImpl) {
            if (--this.invalidations == 0) {
                this.lastRegionInvalidation = this.region.getRegionFactory().nextTimestamp();
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("End invalidating region: " + this.region.getName()));
        }
    }

    @Override
    public long getLastRegionInvalidation() {
        return this.lastRegionInvalidation;
    }

    @Override
    public String getName() {
        return this.region.getName();
    }

    @Override
    public void clear() {
        this.region.clear();
    }

    @Override
    public Comparator<Object> getComparator(String subclass) {
        return this.comparatorsByType.get(subclass);
    }

    @Override
    public void addComparator(String name, Comparator<Object> comparator) {
        this.comparatorsByType.put(name, comparator);
    }
}

