/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.Collections;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.SecureLogoutExecutor;

public class SecureLogoutExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "secure-logout";
    public static final String ALLOW_FRONT_CHANNEL_LOGOUT = "allow-front-channel-logout";
    private static final ProviderConfigProperty ALLOW_FRONT_CHANNEL_LOGOUT_PROPERTY = new ProviderConfigProperty("allow-front-channel-logout", "Allow Front-Channel Logout", "If On, then front-channel logout should be allowed. Otherwise, clients should favor other logout mechanisms such as back-channel logout.", "boolean", (Object)false);

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new SecureLogoutExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Enforces certain constraints on how clients should support logout.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.singletonList(ALLOW_FRONT_CHANNEL_LOGOUT_PROPERTY);
    }
}

