/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.sdjwt.SdJwtUtils;

public abstract class SdJws {
    public static final String CLAIM_NAME_ISSUER = "iss";
    private final JWSInput jwsInput;
    private final JsonNode payload;

    public String toJws() {
        if (this.jwsInput == null) {
            throw new IllegalStateException("JWS not yet signed");
        }
        return this.jwsInput.getWireString();
    }

    public JsonNode getPayload() {
        return this.payload;
    }

    protected SdJws(JsonNode payload) {
        this.payload = payload;
        this.jwsInput = null;
    }

    protected SdJws(String jwsString) {
        this.jwsInput = SdJws.parse(jwsString);
        this.payload = SdJws.readPayload(this.jwsInput);
    }

    protected SdJws(JsonNode payload, JWSInput jwsInput) {
        this.payload = payload;
        this.jwsInput = jwsInput;
    }

    protected SdJws(JsonNode payload, SignatureSignerContext signer, String jwsType) {
        this.payload = payload;
        this.jwsInput = SdJws.sign(payload, signer, jwsType);
    }

    protected static JWSInput sign(JsonNode payload, SignatureSignerContext signer, String jwsType) {
        String jwsString = new JWSBuilder().type(jwsType).jsonContent(payload).sign(signer);
        return SdJws.parse(jwsString);
    }

    public void verifySignature(SignatureVerifierContext verifier) throws VerificationException {
        Objects.requireNonNull(verifier, "verifier must not be null");
        try {
            if (!verifier.verify(this.jwsInput.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), this.jwsInput.getSignature())) {
                throw new VerificationException("Invalid jws signature");
            }
        }
        catch (Exception e) {
            throw new VerificationException((Throwable)e);
        }
    }

    private static final JWSInput parse(String jwsString) {
        try {
            return new JWSInput(Objects.requireNonNull(jwsString, "jwsString must not be null"));
        }
        catch (JWSInputException e) {
            throw new RuntimeException(e);
        }
    }

    private static final JsonNode readPayload(JWSInput jwsInput) {
        try {
            return SdJwtUtils.mapper.readTree(jwsInput.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JWSHeader getHeader() {
        return this.jwsInput.getHeader();
    }

    public void verifyIssuedAtClaim() throws VerificationException {
        long iat;
        long now = Instant.now().getEpochSecond();
        if (now < (iat = SdJwtUtils.readTimeClaim(this.payload, "iat"))) {
            throw new VerificationException("jwt issued in the future");
        }
    }

    public void verifyExpClaim() throws VerificationException {
        long exp;
        long now = Instant.now().getEpochSecond();
        if (now >= (exp = SdJwtUtils.readTimeClaim(this.payload, "exp"))) {
            throw new VerificationException("jwt has expired");
        }
    }

    public void verifyNotBeforeClaim() throws VerificationException {
        long nbf;
        long now = Instant.now().getEpochSecond();
        if (now < (nbf = SdJwtUtils.readTimeClaim(this.payload, "nbf"))) {
            throw new VerificationException("jwt not valid yet");
        }
    }

    public void verifyAge(int maxAge) throws VerificationException {
        long iat;
        long now = Instant.now().getEpochSecond();
        if (now - (iat = SdJwtUtils.readTimeClaim(this.getPayload(), "iat")) > (long)maxAge) {
            throw new VerificationException("jwt is too old");
        }
    }

    public void verifyIssClaim(List<String> issuers) throws VerificationException {
        this.verifyClaimAgainstTrustedValues(issuers, CLAIM_NAME_ISSUER);
    }

    public void verifyVctClaim(List<String> vcts) throws VerificationException {
        this.verifyClaimAgainstTrustedValues(vcts, "vct");
    }

    private void verifyClaimAgainstTrustedValues(List<String> trustedValues, String claimName) throws VerificationException {
        String claimValue = SdJwtUtils.readClaim(this.payload, claimName);
        if (!trustedValues.contains(claimValue)) {
            throw new VerificationException(String.format("Unknown '%s' claim value: %s", claimName, claimValue));
        }
    }
}

