/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime.config;

import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.tls.TlsConfiguration;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TCPSSLOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jboss.logging.Logger;

public class TlsConfigUtils {
    private static final Logger log = Logger.getLogger(TlsConfigUtils.class);

    private TlsConfigUtils() {
    }

    public static byte[] read(Path path) {
        byte[] data;
        block15: {
            try {
                InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(ClassPathUtils.toResourceName((Path)path));
                if (resource != null) {
                    try (InputStream is = resource;){
                        data = is.readAllBytes();
                        break block15;
                    }
                }
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    data = is.readAllBytes();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to read file " + String.valueOf(path), e);
            }
        }
        return data;
    }

    public static void configure(TCPSSLOptions options, TlsConfiguration configuration) {
        SSLOptions sslOptions;
        options.setSsl(true);
        if (configuration.getTrustStoreOptions() != null) {
            options.setTrustOptions(configuration.getTrustStoreOptions());
        }
        if (configuration.getKeyStoreOptions() != null) {
            options.setKeyCertOptions(configuration.getKeyStoreOptions());
        }
        if ((sslOptions = configuration.getSSLOptions()) != null) {
            options.setSslHandshakeTimeout(sslOptions.getSslHandshakeTimeout());
            options.setSslHandshakeTimeoutUnit(sslOptions.getSslHandshakeTimeoutUnit());
            for (String suite : sslOptions.getEnabledCipherSuites()) {
                options.addEnabledCipherSuite(suite);
            }
            for (Buffer buffer : sslOptions.getCrlValues()) {
                options.addCrlValue(buffer);
            }
            options.setEnabledSecureTransportProtocols(sslOptions.getEnabledSecureTransportProtocols());
            try {
                options.setUseAlpn(sslOptions.isUseAlpn());
            }
            catch (UnsupportedOperationException e) {
                log.warnf("ALPN configuration not supported by implementation: %s. ALPN setting will be ignored.", (Object)options.getClass().getName());
            }
        }
    }

    public static void configure(ClientOptionsBase options, TlsConfiguration configuration) {
        TlsConfigUtils.configure((TCPSSLOptions)options, configuration);
        if (configuration.isTrustAll()) {
            options.setTrustAll(true);
        }
    }

    public static void configure(NetClientOptions options, TlsConfiguration configuration) {
        TlsConfigUtils.configure((ClientOptionsBase)options, configuration);
        if (configuration.getHostnameVerificationAlgorithm().isPresent()) {
            options.setHostnameVerificationAlgorithm((String)configuration.getHostnameVerificationAlgorithm().get());
        }
    }

    public static void configure(HttpClientOptions options, TlsConfiguration configuration) {
        TlsConfigUtils.configure((ClientOptionsBase)options, configuration);
        options.setForceSni(configuration.usesSni());
        if (configuration.getHostnameVerificationAlgorithm().isPresent() && ((String)configuration.getHostnameVerificationAlgorithm().get()).equals("NONE")) {
            options.setVerifyHost(false);
        }
    }

    public static void configure(WebSocketClientOptions options, TlsConfiguration configuration) {
        TlsConfigUtils.configure((ClientOptionsBase)options, configuration);
        if (configuration.getHostnameVerificationAlgorithm().isPresent() && ((String)configuration.getHostnameVerificationAlgorithm().get()).equals("NONE")) {
            options.setVerifyHost(false);
        }
    }
}

