/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.predicate;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Filter;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class FilterPredicate
implements Predicate {
    private final List<FilterFragmentPredicate> fragments = new ArrayList<FilterFragmentPredicate>();
    private List<FilterJdbcParameter> parameters;

    public void applyFragment(FilterFragmentPredicate predicate) {
        this.fragments.add(predicate);
    }

    public void applyFragment(String processedFragment, Filter filter, List<String> parameterNames) {
        this.fragments.add(new FilterFragmentPredicate(processedFragment, filter, parameterNames));
    }

    public void applyParameter(FilterJdbcParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<FilterJdbcParameter>();
        }
        this.parameters.add(parameter);
    }

    public List<FilterFragmentPredicate> getFragments() {
        return this.fragments;
    }

    public List<FilterJdbcParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isEmpty() {
        return this.fragments.isEmpty();
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitFilterPredicate(this);
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return null;
    }

    public static class FilterFragmentPredicate
    implements Predicate {
        private final Filter filter;
        private final String sqlFragment;
        private final List<FilterFragmentParameter> parameters;

        public FilterFragmentPredicate(String sqlFragment, Filter filter, List<String> parameterNames) {
            this.filter = filter;
            this.sqlFragment = sqlFragment;
            if (CollectionHelper.isEmpty(parameterNames)) {
                this.parameters = null;
            } else {
                this.parameters = CollectionHelper.arrayList(parameterNames.size());
                for (int i = 0; i < parameterNames.size(); ++i) {
                    String paramName = parameterNames.get(i);
                    Object paramValue = filter.getParameterValue(paramName);
                    JdbcMapping jdbcMapping = filter.getFilterDefinition().getParameterJdbcMapping(paramName);
                    this.parameters.add(new FilterFragmentParameter(filter.getName(), paramName, jdbcMapping, paramValue));
                }
            }
        }

        public Filter getFilter() {
            return this.filter;
        }

        public String getFilterName() {
            return this.filter.getName();
        }

        public String getSqlFragment() {
            return this.sqlFragment;
        }

        public List<FilterFragmentParameter> getParameters() {
            return this.parameters;
        }

        @Override
        public void accept(SqlAstWalker sqlTreeWalker) {
            sqlTreeWalker.visitFilterFragmentPredicate(this);
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class FilterFragmentParameter {
        private final String filterName;
        private final String parameterName;
        private final JdbcMapping valueMapping;
        private final Object value;

        public FilterFragmentParameter(String filterName, String parameterName, JdbcMapping valueMapping, Object value) {
            this.filterName = filterName;
            this.parameterName = parameterName;
            this.valueMapping = valueMapping;
            this.value = value;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public JdbcMapping getValueMapping() {
            return this.valueMapping;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

