/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import org.hibernate.CacheMode;

public final class CacheModeHelper {
    public static final CacheMode DEFAULT_LEGACY_MODE = CacheMode.NORMAL;
    public static final CacheStoreMode DEFAULT_STORE_MODE = CacheStoreMode.USE;
    public static final CacheRetrieveMode DEFAULT_RETRIEVE_MODE = CacheRetrieveMode.USE;

    private CacheModeHelper() {
    }

    public static CacheMode interpretCacheMode(CacheStoreMode storeMode, CacheRetrieveMode retrieveMode) {
        if (storeMode == null) {
            storeMode = DEFAULT_STORE_MODE;
        }
        if (retrieveMode == null) {
            retrieveMode = DEFAULT_RETRIEVE_MODE;
        }
        boolean get = CacheRetrieveMode.USE == retrieveMode;
        return switch (storeMode) {
            default -> throw new IncompatibleClassChangeError();
            case CacheStoreMode.USE -> {
                if (get) {
                    yield CacheMode.NORMAL;
                }
                yield CacheMode.PUT;
            }
            case CacheStoreMode.BYPASS -> {
                if (get) {
                    yield CacheMode.GET;
                }
                yield CacheMode.IGNORE;
            }
            case CacheStoreMode.REFRESH -> CacheMode.REFRESH;
        };
    }

    public static CacheMode effectiveCacheMode(CacheStoreMode storeMode, CacheRetrieveMode retrieveMode) {
        return storeMode == null && retrieveMode == null ? null : CacheModeHelper.interpretCacheMode(storeMode, retrieveMode);
    }

    public static CacheStoreMode interpretCacheStoreMode(CacheMode cacheMode) {
        if (cacheMode == null) {
            cacheMode = DEFAULT_LEGACY_MODE;
        }
        return switch (cacheMode) {
            case CacheMode.NORMAL, CacheMode.PUT -> CacheStoreMode.USE;
            case CacheMode.REFRESH -> CacheStoreMode.REFRESH;
            default -> CacheStoreMode.BYPASS;
        };
    }

    public static CacheRetrieveMode interpretCacheRetrieveMode(CacheMode cacheMode) {
        if (cacheMode == null) {
            cacheMode = DEFAULT_LEGACY_MODE;
        }
        return CacheMode.NORMAL == cacheMode || CacheMode.GET == cacheMode ? CacheRetrieveMode.USE : CacheRetrieveMode.BYPASS;
    }
}

