/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.TimeZone;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.format.FormatMapper;
import org.hibernate.type.spi.TypeConfiguration;

class SessionFactoryBasedWrapperOptions
implements WrapperOptions {
    private final SessionFactoryImplementor factory;

    SessionFactoryBasedWrapperOptions(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        throw new UnsupportedOperationException("No session");
    }

    @Override
    public boolean useStreamForLobBinding() {
        return this.factory.getJdbcServices().getJdbcEnvironment().getDialect().useInputStreamToInsertBlob();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.factory.getSessionFactoryOptions().getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public LobCreator getLobCreator() {
        return this.factory.getJdbcServices().getLobCreator(this.getSession());
    }

    @Override
    public TimeZone getJdbcTimeZone() {
        return this.factory.getSessionFactoryOptions().getJdbcTimeZone();
    }

    @Override
    public Dialect getDialect() {
        return this.factory.getJdbcServices().getJdbcEnvironment().getDialect();
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.factory.getTypeConfiguration();
    }

    @Override
    public FormatMapper getXmlFormatMapper() {
        return this.factory.getSessionFactoryOptions().getXmlFormatMapper();
    }

    @Override
    public FormatMapper getJsonFormatMapper() {
        return this.factory.getSessionFactoryOptions().getJsonFormatMapper();
    }
}

